/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.baggage.propagation;

import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.BitSet;
import org.rascalmpl.javax.annotation.Nullable;

class Element
extends Object {
    private static final BitSet EXCLUDED_KEY_CHARS = new BitSet(128);
    private static final BitSet EXCLUDED_VALUE_CHARS = new BitSet(128);
    private final BitSet excluded;
    private boolean leadingSpace;
    private boolean readingValue;
    private boolean trailingSpace;
    private int start;
    private int end;
    @Nullable
    private String value;

    static Element createKeyElement() {
        return new Element(EXCLUDED_KEY_CHARS);
    }

    static Element createValueElement() {
        return new Element(EXCLUDED_VALUE_CHARS);
    }

    private Element(BitSet excluded) {
        this.excluded = excluded;
        this.reset(0);
    }

    @Nullable
    String getValue() {
        return this.value;
    }

    void reset(int start) {
        this.start = start;
        this.leadingSpace = true;
        this.readingValue = false;
        this.trailingSpace = false;
        this.value = null;
    }

    boolean tryTerminating(int index, String header) {
        if (this.readingValue) {
            this.markEnd(index);
        }
        if (this.trailingSpace) {
            this.setValue(header);
            return true;
        }
        return false;
    }

    private void markEnd(int end) {
        this.end = end;
        this.readingValue = false;
        this.trailingSpace = true;
    }

    private void setValue(String header) {
        this.value = header.substring(this.start, this.end);
    }

    boolean tryNextChar(char character, int index) {
        if (Element.isWhitespace(character)) {
            return this.tryNextWhitespace(index);
        }
        if (this.isExcluded(character)) {
            return false;
        }
        return this.tryNextTokenChar(index);
    }

    private static boolean isWhitespace(char character) {
        return character == ' ' || character == '\t';
    }

    private boolean tryNextWhitespace(int index) {
        if (this.readingValue) {
            this.markEnd(index);
        }
        return true;
    }

    private boolean isExcluded(char character) {
        return character <= ' ' || character >= '\u007f' || this.excluded.get((int)character);
    }

    private boolean tryNextTokenChar(int index) {
        if (this.leadingSpace) {
            this.markStart(index);
        }
        return !this.trailingSpace;
    }

    private void markStart(int start) {
        this.start = start;
        this.readingValue = true;
        this.leadingSpace = false;
    }

    static {
        for (char c : new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}'}) {
            EXCLUDED_KEY_CHARS.set((int)c);
        }
        for (char c : new char[]{'\"', ',', ';', '\\'}) {
            EXCLUDED_VALUE_CHARS.set((int)c);
        }
    }
}

