/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.common;

import org.rascalmpl.io.opentelemetry.api.common.ArrayBackedAttributes;
import org.rascalmpl.io.opentelemetry.api.common.ArrayBackedAttributesBuilder;
import org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.io.opentelemetry.api.common.AttributesBuilder;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.function.BiConsumer;
import org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public interface Attributes {
    @Nullable
    public <T extends Object> T get(AttributeKey<T> var1);

    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> var1);

    public int size();

    public boolean isEmpty();

    public Map<AttributeKey<?>, Object> asMap();

    public static Attributes empty() {
        return ArrayBackedAttributes.EMPTY;
    }

    public static <T extends Object> Attributes of(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return Attributes.empty();
        }
        return new ArrayBackedAttributes(new Object[]{key, value});
    }

    public static <T extends Object, U extends Object> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2) {
        if (key1 == null || key1.getKey().isEmpty() || value1 == null) {
            return Attributes.of(key2, value2);
        }
        if (key2 == null || key2.getKey().isEmpty() || value2 == null) {
            return Attributes.of(key1, value1);
        }
        if (key1.getKey().equals((Object)key2.getKey())) {
            return Attributes.of(key2, value2);
        }
        if (key1.getKey().compareTo(key2.getKey()) > 0) {
            return new ArrayBackedAttributes(new Object[]{key2, value2, key1, value1});
        }
        return new ArrayBackedAttributes(new Object[]{key1, value1, key2, value2});
    }

    public static <T extends Object, U extends Object, V extends Object> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3) {
        return ArrayBackedAttributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3);
    }

    public static <T extends Object, U extends Object, V extends Object, W extends Object> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4) {
        return ArrayBackedAttributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public static <T extends Object, U extends Object, V extends Object, W extends Object, X extends Object> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4, AttributeKey<X> key5, X value5) {
        return ArrayBackedAttributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    public static <T extends Object, U extends Object, V extends Object, W extends Object, X extends Object, Y extends Object> Attributes of(AttributeKey<T> key1, T value1, AttributeKey<U> key2, U value2, AttributeKey<V> key3, V value3, AttributeKey<W> key4, W value4, AttributeKey<X> key5, X value5, AttributeKey<Y> key6, Y value6) {
        return ArrayBackedAttributes.sortAndFilterToAttributes(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6);
    }

    public static AttributesBuilder builder() {
        return new ArrayBackedAttributesBuilder();
    }

    public AttributesBuilder toBuilder();
}

