/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.incubator.logs;

import org.rascalmpl.io.opentelemetry.api.incubator.logs.AnyValueArray;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.AnyValueBoolean;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.AnyValueBytes;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.AnyValueDouble;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.AnyValueLong;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.AnyValueString;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.AnyValueType;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.KeyAnyValue;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.KeyAnyValueList;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.nio.ByteBuffer;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;

public interface AnyValue<T extends Object> {
    public static AnyValue<String> of(String value) {
        return AnyValueString.create(value);
    }

    public static AnyValue<Boolean> of(boolean value) {
        return AnyValueBoolean.create(value);
    }

    public static AnyValue<Long> of(long value) {
        return AnyValueLong.create(value);
    }

    public static AnyValue<Double> of(double value) {
        return AnyValueDouble.create(value);
    }

    public static AnyValue<ByteBuffer> of(byte[] value) {
        return AnyValueBytes.create(value);
    }

    public static AnyValue<List<AnyValue<?>>> of(AnyValue<?> ... value) {
        return AnyValueArray.create(value);
    }

    public static AnyValue<List<AnyValue<?>>> of(List<AnyValue<?>> value) {
        return AnyValueArray.create(value);
    }

    public static AnyValue<List<KeyAnyValue>> of(KeyAnyValue ... value) {
        return KeyAnyValueList.create(value);
    }

    public static AnyValue<List<KeyAnyValue>> of(Map<String, AnyValue<?>> value) {
        return KeyAnyValueList.createFromMap(value);
    }

    public AnyValueType getType();

    public T getValue();

    public String asString();
}

