/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.internal;

import org.rascalmpl.com.google.auto.value.AutoValue;
import org.rascalmpl.io.opentelemetry.api.internal.AutoValue_ImmutableSpanContext;
import org.rascalmpl.io.opentelemetry.api.trace.SpanContext;
import org.rascalmpl.io.opentelemetry.api.trace.SpanId;
import org.rascalmpl.io.opentelemetry.api.trace.TraceFlags;
import org.rascalmpl.io.opentelemetry.api.trace.TraceId;
import org.rascalmpl.io.opentelemetry.api.trace.TraceState;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class ImmutableSpanContext
extends Object
implements SpanContext {
    public static final SpanContext INVALID = ImmutableSpanContext.createInternal(TraceId.getInvalid(), SpanId.getInvalid(), TraceFlags.getDefault(), TraceState.getDefault(), false, false);

    private static AutoValue_ImmutableSpanContext createInternal(String traceId, String spanId, TraceFlags traceFlags, TraceState traceState, boolean remote, boolean valid) {
        return new AutoValue_ImmutableSpanContext(traceId, spanId, traceFlags, traceState, remote, valid);
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState, boolean remote, boolean skipIdValidation) {
        if (skipIdValidation || SpanId.isValid((CharSequence)spanIdHex) && TraceId.isValid((CharSequence)traceIdHex)) {
            return ImmutableSpanContext.createInternal(traceIdHex, spanIdHex, traceFlags, traceState, remote, true);
        }
        return ImmutableSpanContext.createInternal(TraceId.getInvalid(), SpanId.getInvalid(), traceFlags, traceState, remote, false);
    }

    @Override
    public abstract boolean isValid();
}

