/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.internal;

import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.lang.reflect.Array;
import org.rascalmpl.java.util.AbstractMap;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.javax.annotation.Nullable;

public final class ReadOnlyArrayMap<K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object>
extends AbstractMap<K, V> {
    private final List<org.rascalmpl.java.lang.Object> array;
    private final int size;

    public static <K extends org.rascalmpl.java.lang.Object, V extends org.rascalmpl.java.lang.Object> Map<K, V> wrap(List<org.rascalmpl.java.lang.Object> array) {
        if (array.isEmpty()) {
            return Collections.emptyMap();
        }
        return new ReadOnlyArrayMap<K, V>(array);
    }

    private ReadOnlyArrayMap(List<org.rascalmpl.java.lang.Object> array) {
        this.array = array;
        this.size = array.size() / 2;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(org.rascalmpl.java.lang.Object o) {
        if (o == null) {
            return false;
        }
        return this.arrayIndexOfKey(o) != -1;
    }

    public boolean containsValue(org.rascalmpl.java.lang.Object o) {
        for (int i = 0; i < this.array.size(); i += 2) {
            if (!this.value(i + 1).equals(o)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public V get(org.rascalmpl.java.lang.Object o) {
        if (o == null) {
            return null;
        }
        int i = this.arrayIndexOfKey(o);
        return i != -1 ? (V)this.value(i + 1) : null;
    }

    int arrayIndexOfKey(org.rascalmpl.java.lang.Object o) {
        int result = -1;
        for (int i = 0; i < this.array.size(); i += 2) {
            if (!o.equals(this.key(i))) continue;
            return i;
        }
        return result;
    }

    K key(int i) {
        return (K)this.array.get(i);
    }

    V value(int i) {
        return (V)this.array.get(i);
    }

    public Set<K> keySet() {
        return new KeySetView();
    }

    public Collection<V> values() {
        return new ValuesView();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetView();
    }

    public boolean isEmpty() {
        return false;
    }

    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    public V remove(org.rascalmpl.java.lang.Object key) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends K, ? extends V> m4) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append((String)"org.rascalmpl.ReadOnlyArrayMap{");
        for (int i = 0; i < this.array.size(); i += 2) {
            result.append(this.key(i)).append('=').append(this.value(i + 1));
            result.append(',');
        }
        result.setLength(result.length() - 1);
        return result.append((String)"org.rascalmpl.}").toString();
    }

    final class KeySetView
    extends SetView<K> {
        KeySetView() {
        }

        @Override
        K elementAtArrayIndex(int i) {
            return ReadOnlyArrayMap.this.key(i);
        }

        public boolean contains(org.rascalmpl.java.lang.Object o) {
            return ReadOnlyArrayMap.this.containsKey(o);
        }
    }

    final class ValuesView
    extends SetView<V> {
        ValuesView() {
        }

        @Override
        V elementAtArrayIndex(int i) {
            return ReadOnlyArrayMap.this.value(i + 1);
        }

        public boolean contains(org.rascalmpl.java.lang.Object o) {
            return ReadOnlyArrayMap.this.containsValue(o);
        }
    }

    final class EntrySetView
    extends SetView<Map.Entry<K, V>> {
        EntrySetView() {
        }

        @Override
        Map.Entry<K, V> elementAtArrayIndex(int i) {
            return new AbstractMap.SimpleImmutableEntry(ReadOnlyArrayMap.this.key(i), ReadOnlyArrayMap.this.value(i + 1));
        }

        public boolean contains(org.rascalmpl.java.lang.Object o) {
            if (!(o instanceof Map.Entry) || ((Map.Entry)o).getKey() == null) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            int i = ReadOnlyArrayMap.this.arrayIndexOfKey(that.getKey());
            if (i == -1) {
                return false;
            }
            return ReadOnlyArrayMap.this.value(i + 1).equals(that.getValue());
        }
    }

    abstract class SetView<E extends org.rascalmpl.java.lang.Object>
    extends org.rascalmpl.java.lang.Object
    implements Set<E> {
        SetView() {
        }

        public int size() {
            return ReadOnlyArrayMap.this.size;
        }

        abstract E elementAtArrayIndex(int var1);

        public Iterator<E> iterator() {
            return new ReadOnlyIterator();
        }

        public org.rascalmpl.java.lang.Object[] toArray() {
            return this.copyTo(new org.rascalmpl.java.lang.Object[ReadOnlyArrayMap.this.size]);
        }

        public <T extends org.rascalmpl.java.lang.Object> T[] toArray(T[] a) {
            T[] result = a.length >= ReadOnlyArrayMap.this.size ? a : (org.rascalmpl.java.lang.Object[])Array.newInstance((Class)a.getClass().getComponentType(), (int)this.size());
            return this.copyTo((org.rascalmpl.java.lang.Object[])result);
        }

        <T extends org.rascalmpl.java.lang.Object> T[] copyTo(T[] dest) {
            int d = 0;
            for (int i = 0; i < ReadOnlyArrayMap.this.array.size(); i += 2) {
                dest[d++] = this.elementAtArrayIndex(i);
            }
            return dest;
        }

        public boolean containsAll(Collection<?> c) {
            if (c == null) {
                return false;
            }
            if (c.isEmpty()) {
                return true;
            }
            for (org.rascalmpl.java.lang.Object element : c) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(org.rascalmpl.java.lang.Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        final class ReadOnlyIterator
        extends org.rascalmpl.java.lang.Object
        implements Iterator<E> {
            int current = 0;

            ReadOnlyIterator() {
            }

            public boolean hasNext() {
                return this.current < ReadOnlyArrayMap.this.array.size();
            }

            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = SetView.this.elementAtArrayIndex(this.current);
                this.current += 2;
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

