/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.internal;

import org.rascalmpl.io.opentelemetry.api.internal.Contract;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public final class StringUtils
extends Object {
    @Contract(value="org.rascalmpl.null -> true")
    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String padLeft(String value, int minLength) {
        return StringUtils.padStart(value, minLength, '0');
    }

    private static String padStart(String string, int minLength, char padChar) {
        Objects.requireNonNull((Object)string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public static boolean isPrintableString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtils.isPrintableChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrintableChar(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    private StringUtils() {
    }
}

