/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.trace;

import org.rascalmpl.io.opentelemetry.api.internal.StringUtils;
import org.rascalmpl.io.opentelemetry.api.trace.ArrayBasedTraceState;
import org.rascalmpl.io.opentelemetry.api.trace.TraceState;
import org.rascalmpl.io.opentelemetry.api.trace.TraceStateBuilder;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;
import org.rascalmpl.javax.annotation.Nullable;

final class ArrayBasedTraceStateBuilder
extends Object
implements TraceStateBuilder {
    private static final int MAX_VENDOR_ID_SIZE = 13;
    private static final ArrayBasedTraceState EMPTY = ArrayBasedTraceState.create((List<String>)Collections.emptyList());
    private static final int MAX_ENTRIES = 32;
    private static final int KEY_MAX_SIZE = 256;
    private static final int VALUE_MAX_SIZE = 256;
    private static final int MAX_TENANT_ID_SIZE = 240;
    private final List<String> reversedEntries;
    int numEntries;

    static TraceState empty() {
        return EMPTY;
    }

    ArrayBasedTraceStateBuilder() {
        this.reversedEntries = new ArrayList();
        this.numEntries = 0;
    }

    ArrayBasedTraceStateBuilder(ArrayBasedTraceState parent) {
        List<String> entries = parent.getEntries();
        int size = entries.size();
        this.reversedEntries = new ArrayList(size);
        for (int i = size - 2; i >= 0; i -= 2) {
            this.reversedEntries.add((Object)((String)entries.get(i)));
            this.reversedEntries.add((Object)((String)entries.get(i + 1)));
        }
        this.numEntries = size / 2;
    }

    @Override
    public TraceStateBuilder put(String key, String value) {
        if (!ArrayBasedTraceStateBuilder.isKeyValid(key) || !ArrayBasedTraceStateBuilder.isValueValid(value) || this.numEntries >= 32) {
            return this;
        }
        for (int i = 0; i < this.reversedEntries.size(); i += 2) {
            if (!((String)this.reversedEntries.get(i)).equals((Object)key)) continue;
            String currentValue = (String)this.reversedEntries.get(i + 1);
            this.reversedEntries.set(i + 1, (Object)value);
            if (currentValue == null) {
                ++this.numEntries;
            }
            return this;
        }
        this.reversedEntries.add((Object)key);
        this.reversedEntries.add((Object)value);
        ++this.numEntries;
        return this;
    }

    @Override
    public TraceStateBuilder remove(String key) {
        if (key == null) {
            return this;
        }
        for (int i = 0; i < this.reversedEntries.size(); i += 2) {
            if (!((String)this.reversedEntries.get(i)).equals((Object)key)) continue;
            this.reversedEntries.set(i + 1, null);
            --this.numEntries;
            return this;
        }
        return this;
    }

    @Override
    public TraceState build() {
        if (this.numEntries == 0) {
            return ArrayBasedTraceStateBuilder.empty();
        }
        if (this.reversedEntries.size() == 2) {
            return ArrayBasedTraceState.create((List<String>)new ArrayList(this.reversedEntries));
        }
        String[] entries = new String[this.numEntries * 2];
        int pos = 0;
        for (int i = this.reversedEntries.size() - 2; i >= 0; i -= 2) {
            String key = (String)this.reversedEntries.get(i);
            String value = (String)this.reversedEntries.get(i + 1);
            if (value == null) continue;
            entries[pos++] = key;
            entries[pos++] = value;
        }
        return ArrayBasedTraceState.create((List<String>)Arrays.asList((Object[])entries));
    }

    private static boolean isKeyValid(@Nullable String key) {
        if (key == null) {
            return false;
        }
        if (key.length() > 256 || key.isEmpty() || ArrayBasedTraceStateBuilder.isNotLowercaseLetterOrDigit(key.charAt(0))) {
            return false;
        }
        boolean isMultiTenantVendorKey = false;
        for (int i = 1; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (ArrayBasedTraceStateBuilder.isNotLegalKeyCharacter(c)) {
                return false;
            }
            if (c != '@') continue;
            if (isMultiTenantVendorKey) {
                return false;
            }
            isMultiTenantVendorKey = true;
            if (i > 240) {
                return false;
            }
            int remainingKeyChars = key.length() - i - 1;
            if (remainingKeyChars <= 13 && remainingKeyChars != 0) continue;
            return false;
        }
        if (!isMultiTenantVendorKey) {
            return ArrayBasedTraceStateBuilder.isNotDigit(key.charAt(0));
        }
        return true;
    }

    private static boolean isNotLegalKeyCharacter(char c) {
        return ArrayBasedTraceStateBuilder.isNotLowercaseLetterOrDigit(c) && c != '_' && c != '-' && c != '@' && c != '*' && c != '/';
    }

    private static boolean isNotLowercaseLetterOrDigit(char ch) {
        return (ch < 'a' || ch > 'z') && ArrayBasedTraceStateBuilder.isNotDigit(ch);
    }

    private static boolean isNotDigit(char ch) {
        return ch < '0' || ch > '9';
    }

    private static boolean isValueValid(@Nullable String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            return false;
        }
        if (value.length() > 256 || value.charAt(value.length() - 1) == ' ') {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != ',' && c != '=' && c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }
}

