/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.trace;

import org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.api.internal.ApiUsageLogger;
import org.rascalmpl.io.opentelemetry.api.trace.Span;
import org.rascalmpl.io.opentelemetry.api.trace.SpanBuilder;
import org.rascalmpl.io.opentelemetry.api.trace.SpanContext;
import org.rascalmpl.io.opentelemetry.api.trace.SpanKind;
import org.rascalmpl.io.opentelemetry.api.trace.Tracer;
import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class DefaultTracer
extends Object
implements Tracer {
    private static final Tracer INSTANCE = new DefaultTracer();

    static Tracer getInstance() {
        return INSTANCE;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        return NoopSpanBuilder.create();
    }

    private DefaultTracer() {
    }

    private static final class NoopSpanBuilder
    extends Object
    implements SpanBuilder {
        @Nullable
        private SpanContext spanContext;

        static NoopSpanBuilder create() {
            return new NoopSpanBuilder();
        }

        @Override
        public Span startSpan() {
            if (this.spanContext == null) {
                this.spanContext = Span.current().getSpanContext();
            }
            return Span.wrap(this.spanContext);
        }

        @Override
        public NoopSpanBuilder setParent(Context context) {
            if (context == null) {
                ApiUsageLogger.log((String)"org.rascalmpl.context is null");
                return this;
            }
            this.spanContext = Span.fromContext(context).getSpanContext();
            return this;
        }

        @Override
        public NoopSpanBuilder setNoParent() {
            this.spanContext = SpanContext.getInvalid();
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext) {
            return this;
        }

        @Override
        public NoopSpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, String value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, long value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, double value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAttribute(String key, boolean value) {
            return this;
        }

        @Override
        public <T extends Object> NoopSpanBuilder setAttribute(AttributeKey<T> key, T value) {
            return this;
        }

        @Override
        public NoopSpanBuilder setAllAttributes(Attributes attributes) {
            return this;
        }

        @Override
        public NoopSpanBuilder setSpanKind(SpanKind spanKind) {
            return this;
        }

        @Override
        public NoopSpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
            return this;
        }

        private NoopSpanBuilder() {
        }
    }
}

