/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.api.trace;

import org.rascalmpl.io.opentelemetry.api.internal.ImmutableSpanContext;
import org.rascalmpl.io.opentelemetry.api.internal.OtelEncodingUtils;
import org.rascalmpl.io.opentelemetry.api.trace.SpanId;
import org.rascalmpl.io.opentelemetry.api.trace.TraceFlags;
import org.rascalmpl.io.opentelemetry.api.trace.TraceId;
import org.rascalmpl.io.opentelemetry.api.trace.TraceState;
import org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanContext {
    public static SpanContext getInvalid() {
        return ImmutableSpanContext.INVALID;
    }

    public static SpanContext create(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState) {
        return ImmutableSpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, false, false);
    }

    public static SpanContext createFromRemoteParent(String traceIdHex, String spanIdHex, TraceFlags traceFlags, TraceState traceState) {
        return ImmutableSpanContext.create(traceIdHex, spanIdHex, traceFlags, traceState, true, false);
    }

    public String getTraceId();

    default public byte[] getTraceIdBytes() {
        return OtelEncodingUtils.bytesFromBase16((CharSequence)this.getTraceId(), TraceId.getLength());
    }

    public String getSpanId();

    default public byte[] getSpanIdBytes() {
        return OtelEncodingUtils.bytesFromBase16((CharSequence)this.getSpanId(), SpanId.getLength());
    }

    default public boolean isSampled() {
        return this.getTraceFlags().isSampled();
    }

    public TraceFlags getTraceFlags();

    public TraceState getTraceState();

    default public boolean isValid() {
        return TraceId.isValid((CharSequence)this.getTraceId()) && SpanId.isValid((CharSequence)this.getSpanId());
    }

    public boolean isRemote();
}

