/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.context;

import org.rascalmpl.io.opentelemetry.context.ContextStorage;
import org.rascalmpl.io.opentelemetry.context.ContextStorageProvider;
import org.rascalmpl.io.opentelemetry.context.ContextStorageWrappers;
import org.rascalmpl.io.opentelemetry.context.StrictContextStorage;
import org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.ServiceLoader;
import org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.java.util.function.Function;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;

final class LazyStorage
extends Object {
    private static final String CONTEXT_STORAGE_PROVIDER_PROPERTY = "org.rascalmpl.io.opentelemetry.context.contextStorageProvider";
    private static final String ENFORCE_DEFAULT_STORAGE_VALUE = "org.rascalmpl.default";
    private static final String ENABLE_STRICT_CONTEXT_PROVIDER_PROPERTY = "org.rascalmpl.io.opentelemetry.context.enableStrictContext";
    private static final Logger logger = Logger.getLogger((String)LazyStorage.class.getName());
    private static final ContextStorage storage;

    static ContextStorage get() {
        return storage;
    }

    static ContextStorage createStorage(AtomicReference<Throwable> deferredStorageFailure) {
        String providerClassName = System.getProperty((String)"org.rascalmpl.io.opentelemetry.context.contextStorageProvider", (String)"org.rascalmpl.");
        if ("org.rascalmpl.default".equals((Object)providerClassName)) {
            return ContextStorage.defaultStorage();
        }
        ArrayList providers = new ArrayList();
        for (ContextStorageProvider provider : ServiceLoader.load(ContextStorageProvider.class)) {
            if (provider.getClass().getName().equals((Object)"org.rascalmpl.io.opentelemetry.sdk.testing.context.SettableContextStorageProvider")) {
                return provider.get();
            }
            providers.add((Object)provider);
        }
        if (providers.isEmpty()) {
            return ContextStorage.defaultStorage();
        }
        if (providerClassName.isEmpty()) {
            if (providers.size() == 1) {
                return ((ContextStorageProvider)providers.get(0)).get();
            }
            deferredStorageFailure.set((Object)new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Found multiple ContextStorageProvider. Set the io.opentelemetry.context.ContextStorageProvider property to the fully qualified class name of the provider to use. Falling back to default ContextStorage. Found providers: ").append((Object)providers).toString()));
            return ContextStorage.defaultStorage();
        }
        for (ContextStorageProvider provider : providers) {
            if (!provider.getClass().getName().equals((Object)providerClassName)) continue;
            return provider.get();
        }
        deferredStorageFailure.set((Object)new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.io.opentelemetry.context.ContextStorageProvider property set but no matching class could be found, requested: ").append(providerClassName).append((String)"org.rascalmpl. but found providers: ").append((Object)providers).toString()));
        return ContextStorage.defaultStorage();
    }

    private LazyStorage() {
    }

    static {
        AtomicReference deferredStorageFailure = new AtomicReference();
        ContextStorage created = LazyStorage.createStorage((AtomicReference<Throwable>)deferredStorageFailure);
        if (Boolean.getBoolean((String)"org.rascalmpl.io.opentelemetry.context.enableStrictContext")) {
            created = StrictContextStorage.create(created);
        }
        for (Function wrapper : ContextStorageWrappers.getWrappers()) {
            created = (ContextStorage)wrapper.apply((Object)created);
        }
        storage = created;
        ContextStorageWrappers.setStorageInitialized();
        Throwable failure = (Throwable)deferredStorageFailure.get();
        if (failure != null) {
            logger.log(Level.WARNING, (String)"org.rascalmpl.ContextStorageProvider initialized failed. Using default", failure);
        }
    }
}

