/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.context;

import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.context.ContextStorage;
import org.rascalmpl.io.opentelemetry.context.Scope;
import org.rascalmpl.io.opentelemetry.context.internal.shaded.AbstractWeakConcurrentMap;
import org.rascalmpl.io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.AutoCloseable;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.StackTraceElement;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.ref.Reference;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.javax.annotation.Nullable;

final class StrictContextStorage
extends org.rascalmpl.java.lang.Object
implements ContextStorage,
AutoCloseable {
    private static final Logger logger = Logger.getLogger((String)StrictContextStorage.class.getName());
    private final ContextStorage delegate;
    private final PendingScopes pendingScopes;

    static StrictContextStorage create(ContextStorage delegate) {
        return new StrictContextStorage(delegate);
    }

    private StrictContextStorage(ContextStorage delegate) {
        this.delegate = delegate;
        this.pendingScopes = PendingScopes.create();
    }

    @Override
    public Scope attach(Context context) {
        String className;
        int i;
        Scope scope = this.delegate.attach(context);
        CallerStackTrace caller = new CallerStackTrace(context);
        StackTraceElement[] stackTrace = caller.getStackTrace();
        for (i = 0; i < stackTrace.length; ++i) {
            StackTraceElement maybeResumptionElement;
            StackTraceElement element = stackTrace[i];
            if (!element.getClassName().equals((org.rascalmpl.java.lang.Object)Context.class.getName()) || !element.getMethodName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.makeCurrent") || i + 2 >= stackTrace.length || !(maybeResumptionElement = stackTrace[i + 2]).getClassName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.kotlin.coroutines.jvm.internal.BaseContinuationImpl") || !maybeResumptionElement.getMethodName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.resumeWith")) continue;
            throw new AssertionError((org.rascalmpl.java.lang.Object)"org.rascalmpl.Attempting to call Context.makeCurrent from inside a Kotlin coroutine. This is not allowed. Use Context.asContextElement provided by opentelemetry-extension-kotlin instead of makeCurrent.");
        }
        for (i = 1; i < stackTrace.length && ((className = stackTrace[i].getClassName()).startsWith((String)"org.rascalmpl.io.opentelemetry.api.") || className.startsWith((String)"org.rascalmpl.io.opentelemetry.sdk.testing.context.SettableContextStorageProvider") || className.startsWith((String)"org.rascalmpl.io.opentelemetry.context.")); ++i) {
        }
        int from = i;
        stackTrace = (StackTraceElement[])Arrays.copyOfRange((org.rascalmpl.java.lang.Object[])stackTrace, (int)from, (int)stackTrace.length);
        caller.setStackTrace(stackTrace);
        return new StrictScope(scope, caller);
    }

    @Override
    @Nullable
    public Context current() {
        return this.delegate.current();
    }

    public void close() {
        this.pendingScopes.expungeStaleEntries();
        List<CallerStackTrace> leaked = this.pendingScopes.drainPendingCallers();
        if (!leaked.isEmpty()) {
            if (leaked.size() > 1) {
                logger.log(Level.SEVERE, (String)"org.rascalmpl.Multiple scopes leaked - first will be thrown as an error.");
                for (CallerStackTrace caller : leaked) {
                    logger.log(Level.SEVERE, (String)"org.rascalmpl.Scope leaked", (Throwable)StrictContextStorage.callerError(caller));
                }
            }
            throw StrictContextStorage.callerError((CallerStackTrace)leaked.get(0));
        }
    }

    static AssertionError callerError(CallerStackTrace caller) {
        AssertionError toThrow = new AssertionError((org.rascalmpl.java.lang.Object)new StringBuilder().append((String)"org.rascalmpl.Thread [").append(caller.threadName).append((String)"org.rascalmpl.] opened a scope of ").append((org.rascalmpl.java.lang.Object)caller.context).append((String)"org.rascalmpl. here:").toString());
        toThrow.setStackTrace(caller.getStackTrace());
        return toThrow;
    }

    static class PendingScopes
    extends WeakConcurrentMap<Scope, CallerStackTrace> {
        private final ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace> map;

        static PendingScopes create() {
            return new PendingScopes((ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace>)new ConcurrentHashMap());
        }

        PendingScopes(ConcurrentHashMap<AbstractWeakConcurrentMap.WeakKey<Scope>, CallerStackTrace> map) {
            super(false, false, map);
            this.map = map;
            Thread thread = new Thread((Runnable)this);
            thread.setName((String)"org.rascalmpl.weak-ref-cleaner-strictcontextstorage");
            thread.setPriority(1);
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * Exception decompiling
         */
        List<CallerStackTrace> drainPendingCallers() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Z
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    Reference reference = this.remove();
                    CallerStackTrace caller = reference != null ? (CallerStackTrace)this.map.remove((org.rascalmpl.java.lang.Object)reference) : null;
                    if (caller == null || caller.closed) continue;
                    logger.log(Level.SEVERE, (String)"org.rascalmpl.Scope garbage collected before being closed.", (Throwable)StrictContextStorage.callerError(caller));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private static /* synthetic */ boolean lambda$drainPendingCallers$0(CallerStackTrace caller) {
            return !caller.closed;
        }
    }

    static class CallerStackTrace
    extends Throwable {
        final String threadName = Thread.currentThread().getName();
        final long threadId = Thread.currentThread().getId();
        final Context context;
        volatile boolean closed;

        CallerStackTrace(Context context) {
            super(new StringBuilder().append((String)"org.rascalmpl.Thread [").append(Thread.currentThread().getName()).append((String)"org.rascalmpl.] opened scope for ").append((org.rascalmpl.java.lang.Object)context).append((String)"org.rascalmpl. here:").toString());
            this.context = context;
        }
    }

    final class StrictScope
    extends org.rascalmpl.java.lang.Object
    implements Scope {
        final Scope delegate;
        final CallerStackTrace caller;

        StrictScope(Scope delegate, CallerStackTrace caller) {
            this.delegate = delegate;
            this.caller = caller;
            StrictContextStorage.this.pendingScopes.put(this, (org.rascalmpl.java.lang.Object)caller);
        }

        @Override
        public void close() {
            this.caller.closed = true;
            StrictContextStorage.this.pendingScopes.remove(this);
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            for (int i = 0; i < stackTrace.length; ++i) {
                StackTraceElement maybeResumptionElement;
                StackTraceElement nextElement;
                StackTraceElement element = stackTrace[i];
                if (!element.getClassName().equals((org.rascalmpl.java.lang.Object)StrictScope.class.getName()) || !element.getMethodName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.close")) continue;
                int maybeResumeWithFrameIndex = i + 2;
                if (i + 1 < stackTrace.length && (nextElement = stackTrace[i + 1]).getClassName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.kotlin.jdk7.AutoCloseableKt") && nextElement.getMethodName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.closeFinally") && i + 2 < stackTrace.length) {
                    maybeResumeWithFrameIndex = i + 3;
                }
                if (stackTrace[maybeResumeWithFrameIndex].getMethodName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.invokeSuspend")) {
                    ++maybeResumeWithFrameIndex;
                }
                if (maybeResumeWithFrameIndex >= stackTrace.length || !(maybeResumptionElement = stackTrace[maybeResumeWithFrameIndex]).getClassName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.kotlin.coroutines.jvm.internal.BaseContinuationImpl") || !maybeResumptionElement.getMethodName().equals((org.rascalmpl.java.lang.Object)"org.rascalmpl.resumeWith")) continue;
                throw new AssertionError((org.rascalmpl.java.lang.Object)"org.rascalmpl.Attempting to close a Scope created by Context.makeCurrent from inside a Kotlin coroutine. This is not allowed. Use Context.asContextElement provided by opentelemetry-extension-kotlin instead of makeCurrent.");
            }
            if (Thread.currentThread().getId() != this.caller.threadId) {
                throw new IllegalStateException(String.format((String)"org.rascalmpl.Thread [%s] opened scope, but thread [%s] closed it", (org.rascalmpl.java.lang.Object[])new org.rascalmpl.java.lang.Object[]{this.caller.threadName, Thread.currentThread().getName()}), (Throwable)this.caller);
            }
            this.delegate.close();
        }

        public String toString() {
            String message = this.caller.getMessage();
            return message != null ? message : super.toString();
        }
    }
}

