/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.context;

import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.context.ContextStorage;
import org.rascalmpl.io.opentelemetry.context.Scope;
import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.ThreadLocal;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.javax.annotation.Nullable;

final class ThreadLocalContextStorage
extends Enum<ThreadLocalContextStorage>
implements ContextStorage {
    public static final /* enum */ ThreadLocalContextStorage INSTANCE = new ThreadLocalContextStorage((String)"org.rascalmpl.INSTANCE", 0);
    private static final Logger logger;
    private static final ThreadLocal<Context> THREAD_LOCAL_STORAGE;
    private static final /* synthetic */ ThreadLocalContextStorage[] $VALUES;

    public static ThreadLocalContextStorage[] values() {
        return (ThreadLocalContextStorage[])$VALUES.clone();
    }

    public static ThreadLocalContextStorage valueOf(String name) {
        return (ThreadLocalContextStorage)Enum.valueOf(ThreadLocalContextStorage.class, (String)name);
    }

    private ThreadLocalContextStorage() {
        super((String)string, n);
    }

    @Override
    public Scope attach(Context toAttach) {
        if (toAttach == null) {
            return NoopScope.INSTANCE;
        }
        Context beforeAttach = this.current();
        if (toAttach == beforeAttach) {
            return NoopScope.INSTANCE;
        }
        THREAD_LOCAL_STORAGE.set((Object)toAttach);
        return new ScopeImpl(beforeAttach, toAttach);
    }

    @Override
    @Nullable
    public Context current() {
        return (Context)THREAD_LOCAL_STORAGE.get();
    }

    private static /* synthetic */ ThreadLocalContextStorage[] $values() {
        return new ThreadLocalContextStorage[]{INSTANCE};
    }

    static {
        $VALUES = ThreadLocalContextStorage.$values();
        logger = Logger.getLogger((String)ThreadLocalContextStorage.class.getName());
        THREAD_LOCAL_STORAGE = new ThreadLocal();
    }

    static final class NoopScope
    extends Enum<NoopScope>
    implements Scope {
        public static final /* enum */ NoopScope INSTANCE = new NoopScope((String)"org.rascalmpl.INSTANCE", 0);
        private static final /* synthetic */ NoopScope[] $VALUES;

        public static NoopScope[] values() {
            return (NoopScope[])$VALUES.clone();
        }

        public static NoopScope valueOf(String name) {
            return (NoopScope)Enum.valueOf(NoopScope.class, (String)name);
        }

        private NoopScope() {
            super((String)string, n);
        }

        @Override
        public void close() {
        }

        private static /* synthetic */ NoopScope[] $values() {
            return new NoopScope[]{INSTANCE};
        }

        static {
            $VALUES = NoopScope.$values();
        }
    }

    private class ScopeImpl
    extends Object
    implements Scope {
        @Nullable
        private final Context beforeAttach;
        private final Context toAttach;
        private boolean closed;

        private ScopeImpl(Context beforeAttach, Context toAttach) {
            this.beforeAttach = beforeAttach;
            this.toAttach = toAttach;
        }

        @Override
        public void close() {
            if (!this.closed && ThreadLocalContextStorage.this.current() == this.toAttach) {
                this.closed = true;
                THREAD_LOCAL_STORAGE.set((Object)this.beforeAttach);
            } else {
                logger.log(Level.FINE, (String)"org.rascalmpl. Trying to close scope which does not represent current context. Ignoring the call.");
            }
        }
    }
}

