/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.context.internal.shaded;

import org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.lang.ref.Reference;
import org.rascalmpl.java.lang.ref.ReferenceQueue;
import org.rascalmpl.java.lang.ref.WeakReference;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.NoSuchElementException;
import org.rascalmpl.java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.java.util.concurrent.ConcurrentMap;

abstract class AbstractWeakConcurrentMap<K extends Object, V extends Object, L extends Object>
extends ReferenceQueue<K>
implements Runnable,
Iterable<Map.Entry<K, V>> {
    final ConcurrentMap<WeakKey<K>, V> target;

    protected AbstractWeakConcurrentMap() {
        this((ConcurrentMap<WeakKey<K>, V>)new ConcurrentHashMap());
    }

    protected AbstractWeakConcurrentMap(ConcurrentMap<WeakKey<K>, V> target) {
        this.target = target;
    }

    protected abstract L getLookupKey(K var1);

    protected abstract void resetLookupKey(L var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Object previousValue;
        java.lang.Object value;
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            value = this.target.get(lookupKey);
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
        if (value == null && (value = this.defaultValue(key)) != null && (previousValue = this.target.putIfAbsent(new WeakKey<K>(key, this), value)) != null) {
            value = previousValue;
        }
        return (V)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfPresent(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            Object object = this.target.get(lookupKey);
            return (V)object;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            boolean bl = this.target.containsKey(lookupKey);
            return bl;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return (V)this.target.put(new WeakKey<K>(key, this), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putIfAbsent(K key, V value) {
        Object previous;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            previous = this.target.get(lookupKey);
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
        return (V)(previous == null ? this.target.putIfAbsent(new WeakKey<K>(key, this), value) : previous);
    }

    public V putIfProbablyAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return (V)this.target.putIfAbsent(new WeakKey<K>(key, this), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        L lookupKey = this.getLookupKey(key);
        try {
            Object object = this.target.remove(lookupKey);
            return (V)object;
        }
        finally {
            this.resetLookupKey(lookupKey);
        }
    }

    public void clear() {
        this.target.clear();
    }

    protected V defaultValue(K key) {
        return null;
    }

    public void expungeStaleEntries() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.target.remove((Object)reference);
        }
    }

    public int approximateSize() {
        return this.target.size();
    }

    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.target.remove((Object)this.remove());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return new EntryIterator(this.target.entrySet().iterator());
    }

    public String toString() {
        return this.target.toString();
    }

    public static final class WeakKey<K extends Object>
    extends WeakReference<K> {
        private final int hashCode;

        WeakKey(K key, ReferenceQueue<? super K> queue) {
            super(key, queue);
            this.hashCode = System.identityHashCode(key);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (other instanceof WeakKey) {
                return ((WeakKey)other).get() == this.get();
            }
            return other.equals((Object)this);
        }

        public String toString() {
            return String.valueOf((Object)this.get());
        }
    }

    private class EntryIterator
    extends Object
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<WeakKey<K>, V>> iterator;
        private Map.Entry<WeakKey<K>, V> nextEntry;
        private K nextKey;

        private EntryIterator(Iterator<Map.Entry<WeakKey<K>, V>> iterator) {
            this.iterator = iterator;
            this.findNext();
        }

        private void findNext() {
            while (this.iterator.hasNext()) {
                this.nextEntry = (Map.Entry)this.iterator.next();
                this.nextKey = ((WeakKey)this.nextEntry.getKey()).get();
                if (this.nextKey == null) continue;
                return;
            }
            this.nextEntry = null;
            this.nextKey = null;
        }

        public boolean hasNext() {
            return this.nextKey != null;
        }

        public Map.Entry<K, V> next() {
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            try {
                SimpleEntry simpleEntry = new SimpleEntry(AbstractWeakConcurrentMap.this, (Object)this.nextKey, this.nextEntry);
                return simpleEntry;
            }
            finally {
                this.findNext();
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SimpleEntry
    extends Object
    implements Map.Entry<K, V> {
        private final K key;
        final Map.Entry<WeakKey<K>, V> entry;
        final /* synthetic */ AbstractWeakConcurrentMap this$0;

        private SimpleEntry(K key, Map.Entry<WeakKey<K>, V> entry) {
            this.this$0 = var1_1;
            this.key = key;
            this.entry = entry;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.entry.getValue();
        }

        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return this.entry.setValue(value);
        }
    }
}

