/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.context.internal.shaded;

import org.rascalmpl.io.opentelemetry.context.internal.shaded.AbstractWeakConcurrentMap;
import org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.lang.ThreadLocal;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.java.util.concurrent.ConcurrentMap;
import org.rascalmpl.java.util.concurrent.atomic.AtomicLong;

public class WeakConcurrentMap<K extends Object, V extends Object>
extends AbstractWeakConcurrentMap<K, V, LookupKey<K>> {
    private static final ThreadLocal<LookupKey<?>> LOOKUP_KEY_CACHE = new ThreadLocal<LookupKey<?>>(){

        protected LookupKey<?> initialValue() {
            return new LookupKey();
        }
    };
    private static final AtomicLong ID = new AtomicLong();
    private final Thread thread;
    private final boolean reuseKeys;

    public WeakConcurrentMap(boolean cleanerThread) {
        this(cleanerThread, WeakConcurrentMap.isPersistentClassLoader(LookupKey.class.getClassLoader()));
    }

    private static boolean isPersistentClassLoader(ClassLoader classLoader) {
        try {
            return classLoader == null || classLoader == ClassLoader.getSystemClassLoader() || classLoader == ClassLoader.getSystemClassLoader().getParent();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public WeakConcurrentMap(boolean cleanerThread, boolean reuseKeys) {
        this(cleanerThread, reuseKeys, (ConcurrentMap<AbstractWeakConcurrentMap.WeakKey<K>, V>)new ConcurrentHashMap());
    }

    public WeakConcurrentMap(boolean cleanerThread, boolean reuseKeys, ConcurrentMap<AbstractWeakConcurrentMap.WeakKey<K>, V> target) {
        super(target);
        this.reuseKeys = reuseKeys;
        if (cleanerThread) {
            this.thread = new Thread((Runnable)this);
            this.thread.setName(new StringBuilder().append((String)"org.rascalmpl.weak-ref-cleaner-").append(ID.getAndIncrement()).toString());
            this.thread.setPriority(1);
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.thread = null;
        }
    }

    @Override
    protected LookupKey<K> getLookupKey(K key) {
        LookupKey<K> lookupKey = this.reuseKeys ? (LookupKey<K>)LOOKUP_KEY_CACHE.get() : new LookupKey<K>();
        return lookupKey.withValue(key);
    }

    @Override
    protected void resetLookupKey(LookupKey<K> lookupKey) {
        lookupKey.reset();
    }

    public Thread getCleanerThread() {
        return this.thread;
    }

    static final class LookupKey<K extends Object>
    extends Object {
        private K key;
        private int hashCode;

        LookupKey() {
        }

        LookupKey<K> withValue(K key) {
            this.key = key;
            this.hashCode = System.identityHashCode(key);
            return this;
        }

        void reset() {
            this.key = null;
            this.hashCode = 0;
        }

        public boolean equals(Object other) {
            if (other instanceof LookupKey) {
                return ((LookupKey)other).key == this.key;
            }
            return ((AbstractWeakConcurrentMap.WeakKey)other).get() == this.key;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class WithInlinedExpunction<K extends Object, V extends Object>
    extends WeakConcurrentMap<K, V> {
        public WithInlinedExpunction() {
            super(false);
        }

        @Override
        public V get(K key) {
            this.expungeStaleEntries();
            return (V)super.get((Object)key);
        }

        @Override
        public boolean containsKey(K key) {
            this.expungeStaleEntries();
            return super.containsKey((Object)key);
        }

        @Override
        public V put(K key, V value) {
            this.expungeStaleEntries();
            return (V)super.put((Object)key, (Object)value);
        }

        @Override
        public V remove(K key) {
            this.expungeStaleEntries();
            return (V)super.remove((Object)key);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            this.expungeStaleEntries();
            return super.iterator();
        }

        @Override
        public int approximateSize() {
            this.expungeStaleEntries();
            return super.approximateSize();
        }
    }
}

