/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.context.propagation;

import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.context.propagation.MultiTextMapPropagator;
import org.rascalmpl.io.opentelemetry.context.propagation.NoopTextMapPropagator;
import org.rascalmpl.io.opentelemetry.context.propagation.TextMapGetter;
import org.rascalmpl.io.opentelemetry.context.propagation.TextMapSetter;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface TextMapPropagator {
    public static TextMapPropagator composite(TextMapPropagator ... propagators) {
        return TextMapPropagator.composite((Iterable<TextMapPropagator>)Arrays.asList((Object[])propagators));
    }

    public static TextMapPropagator composite(Iterable<TextMapPropagator> propagators) {
        ArrayList propagatorsList = new ArrayList();
        for (TextMapPropagator propagator : propagators) {
            propagatorsList.add((Object)propagator);
        }
        if (propagatorsList.isEmpty()) {
            return NoopTextMapPropagator.getInstance();
        }
        if (propagatorsList.size() == 1) {
            return (TextMapPropagator)propagatorsList.get(0);
        }
        return new MultiTextMapPropagator((List<TextMapPropagator>)propagatorsList);
    }

    public static TextMapPropagator noop() {
        return NoopTextMapPropagator.getInstance();
    }

    public Collection<String> fields();

    public <C extends Object> void inject(Context var1, @Nullable C var2, TextMapSetter<C> var3);

    public <C extends Object> Context extract(Context var1, @Nullable C var2, TextMapGetter<C> var3);
}

