/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.exporter.logging;

import org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.io.opentelemetry.sdk.metrics.InstrumentType;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.MetricData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.MetricExporter;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;
import org.rascalmpl.java.util.logging.Handler;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;

public final class LoggingMetricExporter
extends Object
implements MetricExporter {
    private static final Logger logger = Logger.getLogger((String)LoggingMetricExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final AggregationTemporality aggregationTemporality;

    public static LoggingMetricExporter create() {
        return LoggingMetricExporter.create(AggregationTemporality.CUMULATIVE);
    }

    public static LoggingMetricExporter create(AggregationTemporality aggregationTemporality) {
        return new LoggingMetricExporter(aggregationTemporality);
    }

    @Deprecated
    public LoggingMetricExporter() {
        this(AggregationTemporality.CUMULATIVE);
    }

    private LoggingMetricExporter(AggregationTemporality aggregationTemporality) {
        this.aggregationTemporality = aggregationTemporality;
    }

    @Deprecated
    public AggregationTemporality getPreferredTemporality() {
        return this.aggregationTemporality;
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporality;
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        logger.info(new StringBuilder().append((String)"org.rascalmpl.Received a collection of ").append(metrics.size()).append((String)"org.rascalmpl. metrics for export.").toString());
        for (MetricData metricData : metrics) {
            logger.log(Level.INFO, (String)"org.rascalmpl.metric: {0}", (Object)metricData);
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        CompletableResultCode resultCode = new CompletableResultCode();
        for (Handler handler : logger.getHandlers()) {
            try {
                handler.flush();
            }
            catch (Throwable t2) {
                return resultCode.fail();
            }
        }
        return resultCode.succeed();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.INFO, (String)"org.rascalmpl.Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.flush();
    }

    public String toString() {
        return "org.rascalmpl.LoggingMetricExporter{}";
    }
}

