/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.exporter.logging;

import org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.io.opentelemetry.sdk.trace.data.SpanData;
import org.rascalmpl.io.opentelemetry.sdk.trace.export.SpanExporter;
import org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;
import org.rascalmpl.java.util.logging.Handler;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;

public final class LoggingSpanExporter
extends Object
implements SpanExporter {
    private static final Logger logger = Logger.getLogger((String)LoggingSpanExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public static LoggingSpanExporter create() {
        return new LoggingSpanExporter();
    }

    @Deprecated
    public LoggingSpanExporter() {
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        StringBuilder sb = new StringBuilder(60);
        for (SpanData span : spans) {
            sb.setLength(0);
            InstrumentationScopeInfo instrumentationScopeInfo = span.getInstrumentationScopeInfo();
            sb.append((String)"org.rascalmpl.'").append(span.getName()).append((String)"org.rascalmpl.' : ").append(span.getTraceId()).append((String)"org.rascalmpl. ").append(span.getSpanId()).append((String)"org.rascalmpl. ").append((Object)span.getKind()).append((String)"org.rascalmpl. [tracer: ").append(instrumentationScopeInfo.getName()).append((String)"org.rascalmpl.:").append((String)(instrumentationScopeInfo.getVersion() == null ? "org.rascalmpl." : instrumentationScopeInfo.getVersion())).append((String)"org.rascalmpl.] ").append((Object)span.getAttributes());
            logger.log(Level.INFO, sb.toString());
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        CompletableResultCode resultCode = new CompletableResultCode();
        for (Handler handler : logger.getHandlers()) {
            try {
                handler.flush();
            }
            catch (Throwable t2) {
                resultCode.fail();
            }
        }
        return resultCode.succeed();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.INFO, (String)"org.rascalmpl.Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.flush();
    }

    public String toString() {
        return "org.rascalmpl.LoggingSpanExporter{}";
    }
}

