/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.exporter.logging;

import org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.rascalmpl.io.opentelemetry.sdk.logs.export.LogRecordExporter;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.System;
import org.rascalmpl.java.time.Instant;
import org.rascalmpl.java.time.ZoneId;
import org.rascalmpl.java.time.ZoneOffset;
import org.rascalmpl.java.time.format.DateTimeFormatter;
import org.rascalmpl.java.time.temporal.TemporalAccessor;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;

public class SystemOutLogRecordExporter
extends Object
implements LogRecordExporter {
    private static final DateTimeFormatter ISO_FORMAT = DateTimeFormatter.ISO_DATE_TIME;
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public static SystemOutLogRecordExporter create() {
        return new SystemOutLogRecordExporter();
    }

    private SystemOutLogRecordExporter() {
    }

    @Override
    public CompletableResultCode export(Collection<LogRecordData> logs) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        StringBuilder stringBuilder = new StringBuilder(60);
        for (LogRecordData log : logs) {
            stringBuilder.setLength(0);
            SystemOutLogRecordExporter.formatLog(stringBuilder, log);
            System.out.println((Object)stringBuilder);
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    static void formatLog(StringBuilder stringBuilder, LogRecordData log) {
        InstrumentationScopeInfo instrumentationScopeInfo = log.getInstrumentationScopeInfo();
        stringBuilder.append(ISO_FORMAT.format((TemporalAccessor)Instant.ofEpochMilli((long)TimeUnit.NANOSECONDS.toMillis(log.getTimestampEpochNanos())).atZone((ZoneId)ZoneOffset.UTC))).append((String)"org.rascalmpl. ").append((Object)log.getSeverity()).append((String)"org.rascalmpl. '").append(log.getBody().asString()).append((String)"org.rascalmpl.' : ").append(log.getSpanContext().getTraceId()).append((String)"org.rascalmpl. ").append(log.getSpanContext().getSpanId()).append((String)"org.rascalmpl. [scopeInfo: ").append(instrumentationScopeInfo.getName()).append((String)"org.rascalmpl.:").append((String)(instrumentationScopeInfo.getVersion() == null ? "org.rascalmpl." : instrumentationScopeInfo.getVersion())).append((String)"org.rascalmpl.] ").append((Object)log.getAttributes());
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            System.out.println((String)"org.rascalmpl.Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        return "org.rascalmpl.SystemOutLogRecordExporter{}";
    }
}

