/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues;

import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues.ConcurrentCircularArrayQueueL0Pad;
import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues.IndexedQueueSizeUtil;
import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues.MessagePassingQueue;
import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues.QueueProgressIndicators;
import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues.SupportsIterator;
import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.util.Pow2;
import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.util.UnsafeRefArrayAccess;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.Iterator;
import org.rascalmpl.java.util.NoSuchElementException;

abstract class ConcurrentCircularArrayQueue<E extends Object>
extends ConcurrentCircularArrayQueueL0Pad<E>
implements MessagePassingQueue<E>,
IndexedQueueSizeUtil.IndexedQueue,
QueueProgressIndicators,
SupportsIterator {
    protected final long mask;
    protected final E[] buffer;

    ConcurrentCircularArrayQueue(int capacity) {
        int actualCapacity = Pow2.roundToPowerOfTwo(capacity);
        this.mask = actualCapacity - 1;
        this.buffer = UnsafeRefArrayAccess.allocateRefArray((int)actualCapacity);
    }

    @Override
    public int size() {
        return IndexedQueueSizeUtil.size(this, 1);
    }

    @Override
    public boolean isEmpty() {
        return IndexedQueueSizeUtil.isEmpty(this);
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    @Override
    public int capacity() {
        return (int)(this.mask + 1L);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    public Iterator<E> iterator() {
        long cIndex = this.lvConsumerIndex();
        long pIndex = this.lvProducerIndex();
        return new WeakIterator(cIndex, pIndex, this.mask, this.buffer);
    }

    private static class WeakIterator<E extends Object>
    extends Object
    implements Iterator<E> {
        private final long pIndex;
        private final long mask;
        private final E[] buffer;
        private long nextIndex;
        private E nextElement;

        WeakIterator(long cIndex, long pIndex, long mask, E[] buffer) {
            this.nextIndex = cIndex;
            this.pIndex = pIndex;
            this.mask = mask;
            this.buffer = buffer;
            this.nextElement = this.getNext();
        }

        public void remove() {
            throw new UnsupportedOperationException((String)"org.rascalmpl.remove");
        }

        public boolean hasNext() {
            return this.nextElement != null;
        }

        public E next() {
            E e = this.nextElement;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.nextElement = this.getNext();
            return e;
        }

        private E getNext() {
            while (this.nextIndex < this.pIndex) {
                long offset;
                Object e;
                if ((e = UnsafeRefArrayAccess.lvRefElement(this.buffer, (long)(offset = UnsafeRefArrayAccess.calcCircularRefElementOffset(this.nextIndex++, this.mask)))) == null) continue;
                return (E)e;
            }
            return null;
        }
    }
}

