/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.internal.shaded.jctools.util;

import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.util.UnsafeAccess;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;

public final class UnsafeRefArrayAccess
extends Object {
    public static final long REF_ARRAY_BASE;
    public static final int REF_ELEMENT_SHIFT;

    public static <E extends Object> void spRefElement(E[] buffer, long offset, E e) {
        UnsafeAccess.UNSAFE.putObject(buffer, offset, e);
    }

    public static <E extends Object> void soRefElement(E[] buffer, long offset, E e) {
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset, e);
    }

    public static <E extends Object> E lpRefElement(E[] buffer, long offset) {
        return (E)UnsafeAccess.UNSAFE.getObject(buffer, offset);
    }

    public static <E extends Object> E lvRefElement(E[] buffer, long offset) {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset);
    }

    public static long calcRefElementOffset(long index) {
        return REF_ARRAY_BASE + (index << REF_ELEMENT_SHIFT);
    }

    public static long calcCircularRefElementOffset(long index, long mask) {
        return REF_ARRAY_BASE + ((index & mask) << REF_ELEMENT_SHIFT);
    }

    public static <E extends Object> E[] allocateRefArray(int capacity) {
        return new Object[capacity];
    }

    static {
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == scale) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == scale) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.Unknown pointer size: ").append(scale).toString());
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    }
}

