/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk;

import org.rascalmpl.io.opentelemetry.api.OpenTelemetry;
import org.rascalmpl.io.opentelemetry.api.logs.LoggerBuilder;
import org.rascalmpl.io.opentelemetry.api.logs.LoggerProvider;
import org.rascalmpl.io.opentelemetry.api.metrics.MeterBuilder;
import org.rascalmpl.io.opentelemetry.api.metrics.MeterProvider;
import org.rascalmpl.io.opentelemetry.api.trace.Tracer;
import org.rascalmpl.io.opentelemetry.api.trace.TracerBuilder;
import org.rascalmpl.io.opentelemetry.api.trace.TracerProvider;
import org.rascalmpl.io.opentelemetry.context.propagation.ContextPropagators;
import org.rascalmpl.io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.io.opentelemetry.sdk.logs.SdkLoggerProvider;
import org.rascalmpl.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.rascalmpl.io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetrySdk
extends org.rascalmpl.java.lang.Object
implements OpenTelemetry,
Closeable {
    private static final Logger LOGGER = Logger.getLogger((String)OpenTelemetrySdk.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final ObfuscatedTracerProvider tracerProvider;
    private final ObfuscatedMeterProvider meterProvider;
    private final ObfuscatedLoggerProvider loggerProvider;
    private final ContextPropagators propagators;

    OpenTelemetrySdk(SdkTracerProvider tracerProvider, SdkMeterProvider meterProvider, SdkLoggerProvider loggerProvider, ContextPropagators propagators) {
        this.tracerProvider = new ObfuscatedTracerProvider(tracerProvider);
        this.meterProvider = new ObfuscatedMeterProvider(meterProvider);
        this.loggerProvider = new ObfuscatedLoggerProvider(loggerProvider);
        this.propagators = propagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    @Override
    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public SdkTracerProvider getSdkTracerProvider() {
        return this.tracerProvider.unobfuscate();
    }

    @Override
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public SdkMeterProvider getSdkMeterProvider() {
        return this.meterProvider.unobfuscate();
    }

    @Override
    public LoggerProvider getLogsBridge() {
        return this.loggerProvider;
    }

    public SdkLoggerProvider getSdkLoggerProvider() {
        return this.loggerProvider.unobfuscate();
    }

    @Override
    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            LOGGER.info((String)"org.rascalmpl.Multiple shutdown calls");
            return CompletableResultCode.ofSuccess();
        }
        ArrayList results = new ArrayList();
        results.add((org.rascalmpl.java.lang.Object)this.tracerProvider.unobfuscate().shutdown());
        results.add((org.rascalmpl.java.lang.Object)this.meterProvider.unobfuscate().shutdown());
        results.add((org.rascalmpl.java.lang.Object)this.loggerProvider.unobfuscate().shutdown());
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.OpenTelemetrySdk{tracerProvider=").append((org.rascalmpl.java.lang.Object)this.tracerProvider.unobfuscate()).append((String)"org.rascalmpl., meterProvider=").append((org.rascalmpl.java.lang.Object)this.meterProvider.unobfuscate()).append((String)"org.rascalmpl., loggerProvider=").append((org.rascalmpl.java.lang.Object)this.loggerProvider.unobfuscate()).append((String)"org.rascalmpl., propagators=").append((org.rascalmpl.java.lang.Object)this.propagators).append((String)"org.rascalmpl.}").toString();
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    extends org.rascalmpl.java.lang.Object
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Tracer get(String instrumentationScopeName) {
            return this.delegate.get(instrumentationScopeName);
        }

        @Override
        public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
            return this.delegate.get(instrumentationScopeName, instrumentationScopeVersion);
        }

        @Override
        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedMeterProvider
    extends org.rascalmpl.java.lang.Object
    implements MeterProvider {
        private final SdkMeterProvider delegate;

        ObfuscatedMeterProvider(SdkMeterProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public MeterBuilder meterBuilder(String instrumentationScopeName) {
            return this.delegate.meterBuilder(instrumentationScopeName);
        }

        public SdkMeterProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedLoggerProvider
    extends org.rascalmpl.java.lang.Object
    implements LoggerProvider {
        private final SdkLoggerProvider delegate;

        ObfuscatedLoggerProvider(SdkLoggerProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public LoggerBuilder loggerBuilder(String instrumentationScopeName) {
            return this.delegate.loggerBuilder(instrumentationScopeName);
        }

        public SdkLoggerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

