/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk;

import org.rascalmpl.io.opentelemetry.api.GlobalOpenTelemetry;
import org.rascalmpl.io.opentelemetry.context.propagation.ContextPropagators;
import org.rascalmpl.io.opentelemetry.sdk.OpenTelemetrySdk;
import org.rascalmpl.io.opentelemetry.sdk.logs.SdkLoggerProvider;
import org.rascalmpl.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.rascalmpl.io.opentelemetry.sdk.trace.SdkTracerProvider;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.javax.annotation.Nullable;

public final class OpenTelemetrySdkBuilder
extends Object {
    private ContextPropagators propagators = ContextPropagators.noop();
    @Nullable
    private SdkTracerProvider tracerProvider;
    @Nullable
    private SdkMeterProvider meterProvider;
    @Nullable
    private SdkLoggerProvider loggerProvider;

    OpenTelemetrySdkBuilder() {
    }

    public OpenTelemetrySdkBuilder setTracerProvider(SdkTracerProvider tracerProvider) {
        this.tracerProvider = tracerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setMeterProvider(SdkMeterProvider meterProvider) {
        this.meterProvider = meterProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setLoggerProvider(SdkLoggerProvider loggerProvider) {
        this.loggerProvider = loggerProvider;
        return this;
    }

    public OpenTelemetrySdkBuilder setPropagators(ContextPropagators propagators) {
        this.propagators = propagators;
        return this;
    }

    public OpenTelemetrySdk buildAndRegisterGlobal() {
        OpenTelemetrySdk sdk = this.build();
        GlobalOpenTelemetry.set(sdk);
        return sdk;
    }

    public OpenTelemetrySdk build() {
        SdkLoggerProvider loggerProvider;
        SdkMeterProvider meterProvider;
        SdkTracerProvider tracerProvider = this.tracerProvider;
        if (tracerProvider == null) {
            tracerProvider = SdkTracerProvider.builder().build();
        }
        if ((meterProvider = this.meterProvider) == null) {
            meterProvider = SdkMeterProvider.builder().build();
        }
        if ((loggerProvider = this.loggerProvider) == null) {
            loggerProvider = SdkLoggerProvider.builder().build();
        }
        return new OpenTelemetrySdk(tracerProvider, meterProvider, loggerProvider, this.propagators);
    }
}

