/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.autoconfigure;

import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.MetricExporter;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.MetricReader;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.function.BiFunction;
import org.rascalmpl.javax.annotation.Nullable;

final class MetricExporterConfiguration
extends Object {
    private static final Duration DEFAULT_EXPORT_INTERVAL = Duration.ofMinutes((long)1L);
    private static final Map<String, String> EXPORTER_ARTIFACT_ID_BY_NAME = new HashMap();
    private static final Map<String, String> READER_ARTIFACT_ID_BY_NAME;

    static MetricReader configureReader(String name, ConfigProperties config, SpiHelper spiHelper, BiFunction<? super MetricReader, ConfigProperties, ? extends MetricReader> metricReaderCustomizer, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer, List<Closeable> closeables) {
        NamedSpiManager<MetricExporter> spiExportersManager = MetricExporterConfiguration.metricExporterSpiManager(config, spiHelper);
        MetricExporter metricExporter = MetricExporterConfiguration.configureExporter(name, spiExportersManager);
        if (metricExporter == null) {
            NamedSpiManager<MetricReader> spiMetricReadersManager = MetricExporterConfiguration.metricReadersSpiManager(config, spiHelper);
            MetricReader metricReader = MetricExporterConfiguration.configureMetricReader(name, spiMetricReadersManager);
            if (metricReader != null) {
                closeables.add((Object)metricReader);
                MetricReader customizedMetricReader = (MetricReader)metricReaderCustomizer.apply((Object)metricReader, (Object)config);
                if (customizedMetricReader != metricReader) {
                    closeables.add((Object)customizedMetricReader);
                }
                return customizedMetricReader;
            }
            throw new ConfigurationException(new StringBuilder().append((String)"org.rascalmpl.Unrecognized value for otel.metrics.exporter: ").append(name).toString());
        }
        closeables.add((Object)metricExporter);
        MetricExporter customizedMetricExporter = (MetricExporter)metricExporterCustomizer.apply((Object)metricExporter, (Object)config);
        if (customizedMetricExporter != metricExporter) {
            closeables.add((Object)customizedMetricExporter);
        }
        PeriodicMetricReader reader = PeriodicMetricReader.builder(customizedMetricExporter).setInterval(config.getDuration((String)"org.rascalmpl.otel.metric.export.interval", DEFAULT_EXPORT_INTERVAL)).build();
        closeables.add((Object)reader);
        MetricReader customizedMetricReader = (MetricReader)metricReaderCustomizer.apply((Object)reader, (Object)config);
        if (customizedMetricReader != reader) {
            closeables.add((Object)customizedMetricReader);
        }
        return customizedMetricReader;
    }

    /*
     * Exception decompiling
     */
    static NamedSpiManager<MetricReader> metricReadersSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    static MetricReader configureMetricReader(String name, NamedSpiManager<MetricReader> spiMetricReadersManager) {
        MetricReader metricReader = spiMetricReadersManager.getByName(name);
        if (metricReader == null) {
            String artifactId = (String)READER_ARTIFACT_ID_BY_NAME.get((Object)name);
            if (artifactId != null) {
                throw MetricExporterConfiguration.missingArtifactException(name, artifactId);
            }
            return null;
        }
        return metricReader;
    }

    /*
     * Exception decompiling
     */
    static NamedSpiManager<MetricExporter> metricExporterSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    static MetricExporter configureExporter(String name, NamedSpiManager<MetricExporter> spiExportersManager) {
        MetricExporter metricExporter = spiExportersManager.getByName(name);
        if (metricExporter == null) {
            String artifactId = (String)EXPORTER_ARTIFACT_ID_BY_NAME.get((Object)name);
            if (artifactId != null) {
                throw MetricExporterConfiguration.missingArtifactException(name, artifactId);
            }
            return null;
        }
        return metricExporter;
    }

    private static ConfigurationException missingArtifactException(String exporterName, String artifactId) {
        return new ConfigurationException(new StringBuilder().append((String)"org.rascalmpl.otel.metrics.exporter set to \"").append(exporterName).append((String)"org.rascalmpl.\" but ").append(artifactId).append((String)"org.rascalmpl. not found on classpath. Make sure to add it as a dependency.").toString());
    }

    private MetricExporterConfiguration() {
    }

    static {
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.console", (Object)"org.rascalmpl.opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.logging", (Object)"org.rascalmpl.opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.logging-otlp", (Object)"org.rascalmpl.opentelemetry-exporter-logging-otlp");
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.otlp", (Object)"org.rascalmpl.opentelemetry-exporter-otlp");
        READER_ARTIFACT_ID_BY_NAME = new HashMap();
        READER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.prometheus", (Object)"org.rascalmpl.opentelemetry-exporter-prometheus");
    }
}

