/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.autoconfigure;

import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import org.rascalmpl.io.opentelemetry.sdk.trace.export.SpanExporter;
import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.function.BiFunction;

final class SpanExporterConfiguration
extends Object {
    private static final String EXPORTER_NONE = "org.rascalmpl.none";
    private static final Map<String, String> EXPORTER_ARTIFACT_ID_BY_NAME = new HashMap();

    static Map<String, SpanExporter> configureSpanExporters(ConfigProperties config, SpiHelper spiHelper, BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer, List<Closeable> closeables) {
        Set exporterNames = DefaultConfigProperties.getSet(config, (String)"org.rascalmpl.otel.traces.exporter");
        if (exporterNames.contains((Object)"org.rascalmpl.none")) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException((String)"org.rascalmpl.otel.traces.exporter contains none along with other exporters");
            }
            SpanExporter noop = SpanExporter.composite(new SpanExporter[0]);
            SpanExporter customized = (SpanExporter)spanExporterCustomizer.apply((Object)noop, (Object)config);
            if (customized == noop) {
                return Collections.emptyMap();
            }
            closeables.add((Object)customized);
            return Collections.singletonMap((Object)"org.rascalmpl.none", (Object)customized);
        }
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton((Object)"org.rascalmpl.otlp");
        }
        NamedSpiManager<SpanExporter> spiExportersManager = SpanExporterConfiguration.spanExporterSpiManager(config, spiHelper);
        HashMap map = new HashMap();
        for (String exporterName : exporterNames) {
            SpanExporter spanExporter = SpanExporterConfiguration.configureExporter(exporterName, spiExportersManager);
            closeables.add((Object)spanExporter);
            SpanExporter customizedSpanExporter = (SpanExporter)spanExporterCustomizer.apply((Object)spanExporter, (Object)config);
            if (customizedSpanExporter != spanExporter) {
                closeables.add((Object)customizedSpanExporter);
            }
            map.put((Object)exporterName, (Object)customizedSpanExporter);
        }
        return Collections.unmodifiableMap((Map)map);
    }

    /*
     * Exception decompiling
     */
    static NamedSpiManager<SpanExporter> spanExporterSpiManager(ConfigProperties config, SpiHelper spiHelper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static SpanExporter configureExporter(String name, NamedSpiManager<SpanExporter> spiExportersManager) {
        SpanExporter spiExporter = spiExportersManager.getByName(name);
        if (spiExporter == null) {
            String artifactId = (String)EXPORTER_ARTIFACT_ID_BY_NAME.get((Object)name);
            if (artifactId != null) {
                throw new ConfigurationException(new StringBuilder().append((String)"org.rascalmpl.otel.traces.exporter set to \"").append(name).append((String)"org.rascalmpl.\" but ").append(artifactId).append((String)"org.rascalmpl. not found on classpath. Make sure to add it as a dependency.").toString());
            }
            throw new ConfigurationException(new StringBuilder().append((String)"org.rascalmpl.Unrecognized value for otel.traces.exporter: ").append(name).toString());
        }
        return spiExporter;
    }

    private SpanExporterConfiguration() {
    }

    static {
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.console", (Object)"org.rascalmpl.opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.jaeger", (Object)"org.rascalmpl.opentelemetry-exporter-jaeger");
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.logging", (Object)"org.rascalmpl.opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.logging-otlp", (Object)"org.rascalmpl.opentelemetry-exporter-logging-otlp");
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.otlp", (Object)"org.rascalmpl.opentelemetry-exporter-otlp");
        EXPORTER_ARTIFACT_ID_BY_NAME.put((Object)"org.rascalmpl.zipkin", (Object)"org.rascalmpl.opentelemetry-exporter-zipkin");
    }
}

