/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.autoconfigure;

import org.rascalmpl.io.opentelemetry.api.metrics.MeterProvider;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.SpanExporterConfiguration;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import org.rascalmpl.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.rascalmpl.io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import org.rascalmpl.io.opentelemetry.sdk.trace.SpanLimits;
import org.rascalmpl.io.opentelemetry.sdk.trace.SpanLimitsBuilder;
import org.rascalmpl.io.opentelemetry.sdk.trace.SpanProcessor;
import org.rascalmpl.io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import org.rascalmpl.io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import org.rascalmpl.io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import org.rascalmpl.io.opentelemetry.sdk.trace.export.SpanExporter;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.Sampler;
import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.function.BiFunction;

final class TracerProviderConfiguration
extends org.rascalmpl.java.lang.Object {
    private static final double DEFAULT_TRACEIDRATIO_SAMPLE_RATIO = 1.0;
    private static final String PARENTBASED_ALWAYS_ON = "org.rascalmpl.parentbased_always_on";
    private static final List<String> simpleProcessorExporterNames = Arrays.asList((org.rascalmpl.java.lang.Object[])new String[]{"org.rascalmpl.console", "org.rascalmpl.logging"});

    static void configureTracerProvider(SdkTracerProviderBuilder tracerProviderBuilder, ConfigProperties config, SpiHelper spiHelper, MeterProvider meterProvider, BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer, BiFunction<? super SpanProcessor, ConfigProperties, ? extends SpanProcessor> spanProcessorCustomizer, BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer, List<Closeable> closeables) {
        tracerProviderBuilder.setSpanLimits(TracerProviderConfiguration.configureSpanLimits(config));
        String sampler = config.getString((String)"org.rascalmpl.otel.traces.sampler", (String)"org.rascalmpl.parentbased_always_on");
        tracerProviderBuilder.setSampler((Sampler)samplerCustomizer.apply((org.rascalmpl.java.lang.Object)TracerProviderConfiguration.configureSampler(sampler, config, spiHelper), (org.rascalmpl.java.lang.Object)config));
        Map<String, SpanExporter> exportersByName = SpanExporterConfiguration.configureSpanExporters(config, spiHelper, spanExporterCustomizer, closeables);
        List<SpanProcessor> processors = TracerProviderConfiguration.configureSpanProcessors(config, exportersByName, meterProvider, closeables);
        for (SpanProcessor processor : processors) {
            SpanProcessor wrapped = (SpanProcessor)spanProcessorCustomizer.apply((org.rascalmpl.java.lang.Object)processor, (org.rascalmpl.java.lang.Object)config);
            if (wrapped != processor) {
                closeables.add((org.rascalmpl.java.lang.Object)wrapped);
            }
            tracerProviderBuilder.addSpanProcessor(wrapped);
        }
    }

    static List<SpanProcessor> configureSpanProcessors(ConfigProperties config, Map<String, SpanExporter> exportersByName, MeterProvider meterProvider, List<Closeable> closeables) {
        HashMap exportersByNameCopy = new HashMap(exportersByName);
        ArrayList spanProcessors = new ArrayList();
        for (String simpleProcessorExporterNames : TracerProviderConfiguration.simpleProcessorExporterNames) {
            SpanExporter exporter = (SpanExporter)exportersByNameCopy.remove((org.rascalmpl.java.lang.Object)simpleProcessorExporterNames);
            if (exporter == null) continue;
            SpanProcessor spanProcessor = SimpleSpanProcessor.create(exporter);
            closeables.add((org.rascalmpl.java.lang.Object)spanProcessor);
            spanProcessors.add((org.rascalmpl.java.lang.Object)spanProcessor);
        }
        if (!exportersByNameCopy.isEmpty()) {
            SpanExporter compositeSpanExporter = SpanExporter.composite((Iterable<SpanExporter>)exportersByNameCopy.values());
            BatchSpanProcessor spanProcessor = TracerProviderConfiguration.configureBatchSpanProcessor(config, compositeSpanExporter, meterProvider);
            closeables.add((org.rascalmpl.java.lang.Object)spanProcessor);
            spanProcessors.add((org.rascalmpl.java.lang.Object)spanProcessor);
        }
        return spanProcessors;
    }

    static BatchSpanProcessor configureBatchSpanProcessor(ConfigProperties config, SpanExporter exporter, MeterProvider meterProvider) {
        Duration timeout;
        Integer maxExportBatch;
        Integer maxQueue;
        BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder(exporter).setMeterProvider(meterProvider);
        Duration scheduleDelay = config.getDuration((String)"org.rascalmpl.otel.bsp.schedule.delay");
        if (scheduleDelay != null) {
            builder.setScheduleDelay(scheduleDelay);
        }
        if ((maxQueue = config.getInt((String)"org.rascalmpl.otel.bsp.max.queue.size")) != null) {
            builder.setMaxQueueSize(maxQueue.intValue());
        }
        if ((maxExportBatch = config.getInt((String)"org.rascalmpl.otel.bsp.max.export.batch.size")) != null) {
            builder.setMaxExportBatchSize(maxExportBatch.intValue());
        }
        if ((timeout = config.getDuration((String)"org.rascalmpl.otel.bsp.export.timeout")) != null) {
            builder.setExporterTimeout(timeout);
        }
        return builder.build();
    }

    static SpanLimits configureSpanLimits(ConfigProperties config) {
        Integer maxLinks;
        Integer maxEvents;
        Integer maxSpanAttrs;
        Integer maxAttrs;
        Integer maxSpanAttrLength;
        SpanLimitsBuilder builder = SpanLimits.builder();
        Integer maxAttrLength = config.getInt((String)"org.rascalmpl.otel.attribute.value.length.limit");
        if (maxAttrLength != null) {
            builder.setMaxAttributeValueLength(maxAttrLength.intValue());
        }
        if ((maxSpanAttrLength = config.getInt((String)"org.rascalmpl.otel.span.attribute.value.length.limit")) != null) {
            builder.setMaxAttributeValueLength(maxSpanAttrLength.intValue());
        }
        if ((maxAttrs = config.getInt((String)"org.rascalmpl.otel.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxAttrs.intValue());
            builder.setMaxNumberOfAttributesPerEvent(maxAttrs.intValue());
            builder.setMaxNumberOfAttributesPerLink(maxAttrs.intValue());
        }
        if ((maxSpanAttrs = config.getInt((String)"org.rascalmpl.otel.span.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxSpanAttrs.intValue());
        }
        if ((maxEvents = config.getInt((String)"org.rascalmpl.otel.span.event.count.limit")) != null) {
            builder.setMaxNumberOfEvents(maxEvents.intValue());
        }
        if ((maxLinks = config.getInt((String)"org.rascalmpl.otel.span.link.count.limit")) != null) {
            builder.setMaxNumberOfLinks(maxLinks.intValue());
        }
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    static Sampler configureSampler(String sampler, ConfigProperties config, SpiHelper spiHelper) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)Lorg/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Sampler ratioSampler(ConfigProperties config) {
        double ratio = config.getDouble((String)"org.rascalmpl.otel.traces.sampler.arg", 1.0);
        return Sampler.traceIdRatioBased(ratio);
    }

    private TracerProviderConfiguration() {
    }
}

