/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.common.export;

import org.rascalmpl.com.google.auto.value.AutoValue;
import org.rascalmpl.io.opentelemetry.api.internal.Utils;
import org.rascalmpl.io.opentelemetry.sdk.common.export.AutoValue_RetryPolicy;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.time.Duration;

@AutoValue
public abstract class RetryPolicy
extends Object {
    private static final int DEFAULT_MAX_ATTEMPTS = 5;
    private static final int DEFAULT_INITIAL_BACKOFF_SECONDS = 1;
    private static final int DEFAULT_MAX_BACKOFF_SECONDS = 5;
    private static final double DEFAULT_BACKOFF_MULTIPLIER = 1.5;
    private static final RetryPolicy DEFAULT = RetryPolicy.builder().build();

    RetryPolicy() {
    }

    public static RetryPolicy getDefault() {
        return DEFAULT;
    }

    public static RetryPolicyBuilder builder() {
        return new AutoValue_RetryPolicy.Builder().setMaxAttempts(5).setInitialBackoff(Duration.ofSeconds((long)1L)).setMaxBackoff(Duration.ofSeconds((long)5L)).setBackoffMultiplier(1.5);
    }

    public abstract RetryPolicyBuilder toBuilder();

    public abstract int getMaxAttempts();

    public abstract Duration getInitialBackoff();

    public abstract Duration getMaxBackoff();

    public abstract double getBackoffMultiplier();

    @AutoValue.Builder
    public static abstract class RetryPolicyBuilder
    extends Object {
        RetryPolicyBuilder() {
        }

        public abstract RetryPolicyBuilder setMaxAttempts(int var1);

        public abstract RetryPolicyBuilder setInitialBackoff(Duration var1);

        public abstract RetryPolicyBuilder setMaxBackoff(Duration var1);

        public abstract RetryPolicyBuilder setBackoffMultiplier(double var1);

        abstract RetryPolicy autoBuild();

        public RetryPolicy build() {
            RetryPolicy retryPolicy = this.autoBuild();
            Utils.checkArgument(retryPolicy.getMaxAttempts() > 1 && retryPolicy.getMaxAttempts() < 6, (String)"org.rascalmpl.maxAttempts must be greater than 1 and less than 6");
            Utils.checkArgument(retryPolicy.getInitialBackoff().toNanos() > 0L, (String)"org.rascalmpl.initialBackoff must be greater than 0");
            Utils.checkArgument(retryPolicy.getMaxBackoff().toNanos() > 0L, (String)"org.rascalmpl.maxBackoff must be greater than 0");
            Utils.checkArgument(retryPolicy.getBackoffMultiplier() > 0.0, (String)"org.rascalmpl.backoffMultiplier must be greater than 0");
            return retryPolicy;
        }
    }
}

