/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.internal;

import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.Runnable;
import org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.lang.Thread;
import org.rascalmpl.java.util.concurrent.Executors;
import org.rascalmpl.java.util.concurrent.ThreadFactory;
import org.rascalmpl.java.util.concurrent.atomic.AtomicInteger;

public final class DaemonThreadFactory
extends Object
implements ThreadFactory {
    private final String namePrefix;
    private final AtomicInteger counter = new AtomicInteger();
    private final ThreadFactory delegate = Executors.defaultThreadFactory();
    private final boolean propagateContextForTesting;

    public DaemonThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    public DaemonThreadFactory(String namePrefix, boolean propagateContextForTesting) {
        this.namePrefix = namePrefix;
        this.propagateContextForTesting = propagateContextForTesting;
    }

    public Thread newThread(Runnable runnable) {
        Thread t2 = this.delegate.newThread(this.propagateContextForTesting ? Context.current().wrap(runnable) : runnable);
        try {
            t2.setDaemon(true);
            t2.setName(new StringBuilder().append(this.namePrefix).append((String)"org.rascalmpl.-").append(this.counter.incrementAndGet()).toString());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return t2;
    }
}

