/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.logs;

import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.io.opentelemetry.sdk.logs.LogRecordProcessor;
import org.rascalmpl.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;

final class MultiLogRecordProcessor
extends Object
implements LogRecordProcessor {
    private final List<LogRecordProcessor> logRecordProcessors;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    static LogRecordProcessor create(List<LogRecordProcessor> logRecordProcessorsList) {
        return new MultiLogRecordProcessor((List<LogRecordProcessor>)new ArrayList((Collection)Objects.requireNonNull(logRecordProcessorsList, (String)"org.rascalmpl.logRecordProcessorsList")));
    }

    @Override
    public void onEmit(Context context, ReadWriteLogRecord logRecord) {
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            logRecordProcessor.onEmit(context, logRecord);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList results = new ArrayList(this.logRecordProcessors.size());
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            results.add((Object)logRecordProcessor.shutdown());
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    @Override
    public CompletableResultCode forceFlush() {
        ArrayList results = new ArrayList(this.logRecordProcessors.size());
        for (LogRecordProcessor logRecordProcessor : this.logRecordProcessors) {
            results.add((Object)logRecordProcessor.forceFlush());
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    private MultiLogRecordProcessor(List<LogRecordProcessor> logRecordProcessorsList) {
        this.logRecordProcessors = logRecordProcessorsList;
    }
}

