/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.logs;

import org.rascalmpl.io.opentelemetry.api.logs.LogRecordBuilder;
import org.rascalmpl.io.opentelemetry.api.logs.Logger;
import org.rascalmpl.io.opentelemetry.api.logs.LoggerProvider;
import org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.io.opentelemetry.sdk.logs.LoggerSharedState;
import org.rascalmpl.io.opentelemetry.sdk.logs.SdkLogRecordBuilder;
import org.rascalmpl.io.opentelemetry.sdk.logs.internal.LoggerConfig;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;

final class SdkLogger
extends Object
implements Logger {
    private static final Logger NOOP_LOGGER = LoggerProvider.noop().get((String)"org.rascalmpl.noop");
    private final LoggerSharedState loggerSharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final LoggerConfig loggerConfig;

    SdkLogger(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo, LoggerConfig loggerConfig) {
        this.loggerSharedState = loggerSharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.loggerConfig = loggerConfig;
    }

    @Override
    public LogRecordBuilder logRecordBuilder() {
        if (this.loggerConfig.isEnabled()) {
            return new SdkLogRecordBuilder(this.loggerSharedState, this.instrumentationScopeInfo);
        }
        return NOOP_LOGGER.logRecordBuilder();
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }
}

