/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.logs.export;

import org.rascalmpl.io.opentelemetry.api.internal.Utils;
import org.rascalmpl.io.opentelemetry.api.metrics.MeterProvider;
import org.rascalmpl.io.opentelemetry.sdk.logs.export.BatchLogRecordProcessor;
import org.rascalmpl.io.opentelemetry.sdk.logs.export.LogRecordExporter;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.TimeUnit;

public final class BatchLogRecordProcessorBuilder
extends Object {
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 1000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    private final LogRecordExporter logRecordExporter;
    private long scheduleDelayNanos = TimeUnit.MILLISECONDS.toNanos(1000L);
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(30000L);
    private MeterProvider meterProvider = MeterProvider.noop();

    BatchLogRecordProcessorBuilder(LogRecordExporter logRecordExporter) {
        this.logRecordExporter = (LogRecordExporter)Objects.requireNonNull((Object)logRecordExporter, (String)"org.rascalmpl.logRecordExporter");
    }

    public BatchLogRecordProcessorBuilder setScheduleDelay(long delay, TimeUnit unit) {
        Objects.requireNonNull((Object)unit, (String)"org.rascalmpl.unit");
        Utils.checkArgument(delay >= 0L, (String)"org.rascalmpl.delay must be non-negative");
        this.scheduleDelayNanos = unit.toNanos(delay);
        return this;
    }

    public BatchLogRecordProcessorBuilder setScheduleDelay(Duration delay) {
        Objects.requireNonNull((Object)delay, (String)"org.rascalmpl.delay");
        return this.setScheduleDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getScheduleDelayNanos() {
        return this.scheduleDelayNanos;
    }

    public BatchLogRecordProcessorBuilder setExporterTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull((Object)unit, (String)"org.rascalmpl.unit");
        Utils.checkArgument(timeout >= 0L, (String)"org.rascalmpl.timeout must be non-negative");
        this.exporterTimeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public BatchLogRecordProcessorBuilder setExporterTimeout(Duration timeout) {
        Objects.requireNonNull((Object)timeout, (String)"org.rascalmpl.timeout");
        return this.setExporterTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getExporterTimeoutNanos() {
        return this.exporterTimeoutNanos;
    }

    public BatchLogRecordProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BatchLogRecordProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        Utils.checkArgument(maxExportBatchSize > 0, (String)"org.rascalmpl.maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    public BatchLogRecordProcessorBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull((Object)meterProvider, (String)"org.rascalmpl.meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BatchLogRecordProcessor build() {
        return new BatchLogRecordProcessor(this.logRecordExporter, this.meterProvider, this.scheduleDelayNanos, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutNanos);
    }
}

