/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.logs.export;

import org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.io.opentelemetry.sdk.logs.data.LogRecordData;
import org.rascalmpl.io.opentelemetry.sdk.logs.export.MultiLogRecordExporter;
import org.rascalmpl.io.opentelemetry.sdk.logs.export.NoopLogRecordExporter;
import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.concurrent.TimeUnit;

public interface LogRecordExporter
extends Closeable {
    public static LogRecordExporter composite(LogRecordExporter ... exporters) {
        return LogRecordExporter.composite((Iterable<LogRecordExporter>)Arrays.asList((Object[])exporters));
    }

    public static LogRecordExporter composite(Iterable<LogRecordExporter> exporters) {
        ArrayList exportersList = new ArrayList();
        for (LogRecordExporter exporter : exporters) {
            exportersList.add((Object)exporter);
        }
        if (exportersList.isEmpty()) {
            return NoopLogRecordExporter.getInstance();
        }
        if (exportersList.size() == 1) {
            return (LogRecordExporter)exportersList.get(0);
        }
        return MultiLogRecordExporter.create((List<LogRecordExporter>)exportersList);
    }

    public CompletableResultCode export(Collection<LogRecordData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

