/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.logs.internal;

import org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.api.incubator.events.EventBuilder;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.AnyValue;
import org.rascalmpl.io.opentelemetry.api.incubator.logs.ExtendedLogRecordBuilder;
import org.rascalmpl.io.opentelemetry.api.logs.LogRecordBuilder;
import org.rascalmpl.io.opentelemetry.api.logs.Severity;
import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.sdk.common.Clock;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.time.Instant;
import org.rascalmpl.java.util.HashMap;
import org.rascalmpl.java.util.Map;
import org.rascalmpl.java.util.concurrent.TimeUnit;

class SdkEventBuilder
extends Object
implements EventBuilder {
    private static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey((String)"org.rascalmpl.event.name");
    private final Map<String, AnyValue<?>> payload = new HashMap();
    private final Clock clock;
    private final LogRecordBuilder logRecordBuilder;
    private final String eventName;
    private boolean hasTimestamp = false;

    SdkEventBuilder(Clock clock, LogRecordBuilder logRecordBuilder, String eventName) {
        this.clock = clock;
        this.logRecordBuilder = logRecordBuilder;
        this.eventName = eventName;
    }

    @Override
    public EventBuilder put(String key, AnyValue<?> value) {
        this.payload.put((Object)key, value);
        return this;
    }

    @Override
    public EventBuilder setTimestamp(long timestamp, TimeUnit unit) {
        this.logRecordBuilder.setTimestamp(timestamp, unit);
        this.hasTimestamp = true;
        return this;
    }

    @Override
    public EventBuilder setTimestamp(Instant instant) {
        this.logRecordBuilder.setTimestamp(instant);
        this.hasTimestamp = true;
        return this;
    }

    @Override
    public EventBuilder setContext(Context context) {
        this.logRecordBuilder.setContext(context);
        return this;
    }

    @Override
    public EventBuilder setSeverity(Severity severity) {
        this.logRecordBuilder.setSeverity(severity);
        return this;
    }

    @Override
    public EventBuilder setAttributes(Attributes attributes) {
        this.logRecordBuilder.setAllAttributes(attributes);
        return this;
    }

    @Override
    public void emit() {
        if (!this.payload.isEmpty()) {
            ((ExtendedLogRecordBuilder)this.logRecordBuilder).setBody(AnyValue.of(this.payload));
        }
        if (!this.hasTimestamp) {
            this.logRecordBuilder.setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS);
        }
        this.logRecordBuilder.setAttribute(EVENT_NAME, this.eventName);
        this.logRecordBuilder.emit();
    }
}

