/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics;

import org.rascalmpl.io.opentelemetry.api.internal.Utils;
import org.rascalmpl.io.opentelemetry.sdk.metrics.InstrumentSelector;
import org.rascalmpl.io.opentelemetry.sdk.metrics.InstrumentType;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.javax.annotation.Nullable;

public final class InstrumentSelectorBuilder
extends Object {
    @Nullable
    private InstrumentType instrumentType;
    @Nullable
    private String instrumentName;
    @Nullable
    private String instrumentUnit;
    @Nullable
    private String meterName;
    @Nullable
    private String meterVersion;
    @Nullable
    private String meterSchemaUrl;

    InstrumentSelectorBuilder() {
    }

    public InstrumentSelectorBuilder setType(InstrumentType instrumentType) {
        Objects.requireNonNull((Object)instrumentType, (String)"org.rascalmpl.instrumentType");
        this.instrumentType = instrumentType;
        return this;
    }

    public InstrumentSelectorBuilder setName(String name) {
        Objects.requireNonNull((Object)name, (String)"org.rascalmpl.name");
        this.instrumentName = name;
        return this;
    }

    public InstrumentSelectorBuilder setUnit(String unit) {
        Objects.requireNonNull((Object)unit, (String)"org.rascalmpl.unit");
        this.instrumentUnit = unit;
        return this;
    }

    public InstrumentSelectorBuilder setMeterName(String meterName) {
        Objects.requireNonNull((Object)meterName, (String)"org.rascalmpl.meterName");
        this.meterName = meterName;
        return this;
    }

    public InstrumentSelectorBuilder setMeterVersion(String meterVersion) {
        Objects.requireNonNull((Object)meterVersion, (String)"org.rascalmpl.meterVersion");
        this.meterVersion = meterVersion;
        return this;
    }

    public InstrumentSelectorBuilder setMeterSchemaUrl(String meterSchemaUrl) {
        Objects.requireNonNull((Object)meterSchemaUrl, (String)"org.rascalmpl.meterSchemaUrl");
        this.meterSchemaUrl = meterSchemaUrl;
        return this;
    }

    public InstrumentSelector build() {
        Utils.checkArgument(this.instrumentType != null || this.instrumentName != null || this.instrumentUnit != null || this.meterName != null || this.meterVersion != null || this.meterSchemaUrl != null, (String)"org.rascalmpl.Instrument selector must contain selection criteria");
        return InstrumentSelector.create(this.instrumentType, this.instrumentName, this.instrumentUnit, this.meterName, this.meterVersion, this.meterSchemaUrl);
    }
}

