/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics;

import org.rascalmpl.io.opentelemetry.sdk.common.Clock;
import org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.io.opentelemetry.sdk.internal.ScopeConfigurator;
import org.rascalmpl.io.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import org.rascalmpl.io.opentelemetry.sdk.metrics.InstrumentSelector;
import org.rascalmpl.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.rascalmpl.io.opentelemetry.sdk.metrics.View;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.MetricProducer;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.MetricReader;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.MeterConfig;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.export.CardinalityLimitSelector;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.IdentityHashMap;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.function.Predicate;

public final class SdkMeterProviderBuilder
extends Object {
    private static final ExemplarFilter DEFAULT_EXEMPLAR_FILTER = ExemplarFilter.traceBased();
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final IdentityHashMap<MetricReader, CardinalityLimitSelector> metricReaders = new IdentityHashMap();
    private final List<MetricProducer> metricProducers = new ArrayList();
    private final List<RegisteredView> registeredViews = new ArrayList();
    private ExemplarFilter exemplarFilter = DEFAULT_EXEMPLAR_FILTER;
    private ScopeConfiguratorBuilder<MeterConfig> meterConfiguratorBuilder = MeterConfig.configuratorBuilder();

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull((Object)clock, (String)"org.rascalmpl.clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull((Object)resource, (String)"org.rascalmpl.resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull((Object)resource, (String)"org.rascalmpl.resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter filter) {
        this.exemplarFilter = filter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull((Object)selector, (String)"org.rascalmpl.selector");
        Objects.requireNonNull((Object)view, (String)"org.rascalmpl.view");
        this.registeredViews.add((Object)RegisteredView.create(selector, view, view.getAttributesProcessor(), view.getCardinalityLimit(), SourceInfo.fromCurrentStack()));
        return this;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReader reader) {
        this.metricReaders.put((Object)reader, (Object)CardinalityLimitSelector.defaultCardinalityLimitSelector());
        return this;
    }

    SdkMeterProviderBuilder registerMetricReader(MetricReader reader, CardinalityLimitSelector cardinalityLimitSelector) {
        this.metricReaders.put((Object)reader, (Object)cardinalityLimitSelector);
        return this;
    }

    public SdkMeterProviderBuilder registerMetricProducer(MetricProducer metricProducer) {
        this.metricProducers.add((Object)metricProducer);
        return this;
    }

    SdkMeterProviderBuilder setMeterConfigurator(ScopeConfigurator<MeterConfig> meterConfigurator) {
        this.meterConfiguratorBuilder = meterConfigurator.toBuilder();
        return this;
    }

    SdkMeterProviderBuilder addMeterConfiguratorCondition(Predicate<InstrumentationScopeInfo> scopeMatcher, MeterConfig meterConfig) {
        this.meterConfiguratorBuilder.addCondition(scopeMatcher, meterConfig);
        return this;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.registeredViews, this.metricReaders, this.metricProducers, this.clock, this.resource, this.exemplarFilter, this.meterConfiguratorBuilder.build());
    }
}

