/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics;

import org.rascalmpl.io.opentelemetry.sdk.metrics.Aggregation;
import org.rascalmpl.io.opentelemetry.sdk.metrics.View;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Set;
import org.rascalmpl.java.util.function.Predicate;
import org.rascalmpl.javax.annotation.Nullable;

public final class ViewBuilder
extends Object {
    @Nullable
    private String name;
    @Nullable
    private String description;
    private Aggregation aggregation = Aggregation.defaultAggregation();
    private AttributesProcessor processor = AttributesProcessor.noop();
    private int cardinalityLimit = 2000;

    ViewBuilder() {
    }

    public ViewBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ViewBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ViewBuilder setAggregation(Aggregation aggregation) {
        if (!(aggregation instanceof AggregatorFactory)) {
            throw new IllegalArgumentException((String)"org.rascalmpl.Custom Aggregation implementations are currently not supported. Use one of the standard implementations returned by the static factories in the Aggregation class.");
        }
        this.aggregation = aggregation;
        return this;
    }

    public ViewBuilder setAttributeFilter(Set<String> keysToRetain) {
        Objects.requireNonNull(keysToRetain, (String)"org.rascalmpl.keysToRetain");
        return this.setAttributeFilter(AttributesProcessor.setIncludes(keysToRetain));
    }

    public ViewBuilder setAttributeFilter(Predicate<String> keyFilter) {
        Objects.requireNonNull(keyFilter, (String)"org.rascalmpl.keyFilter");
        this.processor = AttributesProcessor.filterByKeyName(keyFilter);
        return this;
    }

    ViewBuilder addAttributesProcessor(AttributesProcessor attributesProcessor) {
        this.processor = this.processor.then(attributesProcessor);
        return this;
    }

    ViewBuilder setCardinalityLimit(int cardinalityLimit) {
        if (cardinalityLimit <= 0) {
            throw new IllegalArgumentException((String)"org.rascalmpl.cardinalityLimit must be > 0");
        }
        this.cardinalityLimit = cardinalityLimit;
        return this;
    }

    public View build() {
        return View.create(this.name, this.description, this.aggregation, this.processor, this.cardinalityLimit);
    }
}

