/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics.export;

import org.rascalmpl.io.opentelemetry.api.internal.Utils;
import org.rascalmpl.io.opentelemetry.sdk.internal.DaemonThreadFactory;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.MetricExporter;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.time.Duration;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.Executors;
import org.rascalmpl.java.util.concurrent.ScheduledExecutorService;
import org.rascalmpl.java.util.concurrent.ThreadFactory;
import org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.javax.annotation.Nullable;

public final class PeriodicMetricReaderBuilder
extends Object {
    static final long DEFAULT_SCHEDULE_DELAY_MINUTES = 1L;
    private final MetricExporter metricExporter;
    private long intervalNanos = TimeUnit.MINUTES.toNanos(1L);
    @Nullable
    private ScheduledExecutorService executor;

    PeriodicMetricReaderBuilder(MetricExporter metricExporter) {
        this.metricExporter = metricExporter;
    }

    public PeriodicMetricReaderBuilder setInterval(long interval, TimeUnit unit) {
        Objects.requireNonNull((Object)unit, (String)"org.rascalmpl.unit");
        Utils.checkArgument(interval > 0L, (String)"org.rascalmpl.interval must be positive");
        this.intervalNanos = unit.toNanos(interval);
        return this;
    }

    public PeriodicMetricReaderBuilder setInterval(Duration interval) {
        Objects.requireNonNull((Object)interval, (String)"org.rascalmpl.interval");
        return this.setInterval(interval.toNanos(), TimeUnit.NANOSECONDS);
    }

    public PeriodicMetricReaderBuilder setExecutor(ScheduledExecutorService executor) {
        Objects.requireNonNull((Object)executor, (String)"org.rascalmpl.executor");
        this.executor = executor;
        return this;
    }

    public PeriodicMetricReader build() {
        ScheduledExecutorService executor = this.executor;
        if (executor == null) {
            executor = Executors.newScheduledThreadPool((int)1, (ThreadFactory)new DaemonThreadFactory((String)"org.rascalmpl.PeriodicMetricReader"));
        }
        return new PeriodicMetricReader(this.metricExporter, this.intervalNanos, executor);
    }
}

