/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics.internal;

import org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.io.opentelemetry.sdk.internal.ScopeConfigurator;
import org.rascalmpl.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.rascalmpl.io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import org.rascalmpl.io.opentelemetry.sdk.metrics.ViewBuilder;
import org.rascalmpl.io.opentelemetry.sdk.metrics.export.MetricReader;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.MeterConfig;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.export.CardinalityLimitSelector;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.StringPredicates;
import org.rascalmpl.java.lang.Class;
import org.rascalmpl.java.lang.IllegalAccessException;
import org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.java.lang.Integer;
import org.rascalmpl.java.lang.NoSuchMethodException;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.java.lang.reflect.InvocationTargetException;
import org.rascalmpl.java.lang.reflect.Method;
import org.rascalmpl.java.util.function.Predicate;

public final class SdkMeterProviderUtil
extends Object {
    private SdkMeterProviderUtil() {
    }

    public static void setExemplarFilter(SdkMeterProviderBuilder sdkMeterProviderBuilder, ExemplarFilter exemplarFilter) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod((String)"org.rascalmpl.setExemplarFilter", new Class[]{ExemplarFilter.class});
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, new Object[]{exemplarFilter});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException((String)"org.rascalmpl.Error calling setExemplarFilter on SdkMeterProviderBuilder", (Throwable)e);
        }
    }

    public static void registerMetricReaderWithCardinalitySelector(SdkMeterProviderBuilder sdkMeterProviderBuilder, MetricReader metricReader, CardinalityLimitSelector cardinalityLimitSelector) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod((String)"org.rascalmpl.registerMetricReader", new Class[]{MetricReader.class, CardinalityLimitSelector.class});
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, new Object[]{metricReader, cardinalityLimitSelector});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException((String)"org.rascalmpl.Error calling addMetricReader on SdkMeterProviderBuilder", (Throwable)e);
        }
    }

    public static void setMeterConfigurator(SdkMeterProviderBuilder sdkMeterProviderBuilder, ScopeConfigurator<MeterConfig> meterConfigurator) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod((String)"org.rascalmpl.setMeterConfigurator", new Class[]{ScopeConfigurator.class});
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, new Object[]{meterConfigurator});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException((String)"org.rascalmpl.Error calling setMeterConfigurator on SdkMeterProviderBuilder", (Throwable)e);
        }
    }

    public static void addMeterConfiguratorCondition(SdkMeterProviderBuilder sdkMeterProviderBuilder, Predicate<InstrumentationScopeInfo> scopeMatcher, MeterConfig meterConfig) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod((String)"org.rascalmpl.addMeterConfiguratorCondition", new Class[]{Predicate.class, MeterConfig.class});
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, new Object[]{scopeMatcher, meterConfig});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException((String)"org.rascalmpl.Error calling addMeterConfiguratorCondition on SdkMeterProviderBuilder", (Throwable)e);
        }
    }

    public static void appendFilteredBaggageAttributes(ViewBuilder viewBuilder, Predicate<String> keyFilter) {
        SdkMeterProviderUtil.addAttributesProcessor(viewBuilder, AttributesProcessor.appendBaggageByKeyName(keyFilter));
    }

    public static void appendAllBaggageAttributes(ViewBuilder viewBuilder) {
        SdkMeterProviderUtil.appendFilteredBaggageAttributes(viewBuilder, StringPredicates.ALL);
    }

    private static void addAttributesProcessor(ViewBuilder viewBuilder, AttributesProcessor attributesProcessor) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod((String)"org.rascalmpl.addAttributesProcessor", new Class[]{AttributesProcessor.class});
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, new Object[]{attributesProcessor});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException((String)"org.rascalmpl.Error adding AttributesProcessor to ViewBuilder", (Throwable)e);
        }
    }

    public static void setCardinalityLimit(ViewBuilder viewBuilder, int cardinalityLimit) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod((String)"org.rascalmpl.setCardinalityLimit", new Class[]{Integer.TYPE});
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, new Object[]{Integer.valueOf((int)cardinalityLimit)});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException((String)"org.rascalmpl.Error setting cardinalityLimit on ViewBuilder", (Throwable)e);
        }
    }

    public static void resetForTest(SdkMeterProvider sdkMeterProvider) {
        try {
            Method method = SdkMeterProvider.class.getDeclaredMethod((String)"org.rascalmpl.resetForTest", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProvider, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException((String)"org.rascalmpl.Error calling resetForTest on SdkMeterProvider", (Throwable)e);
        }
    }
}

