/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator;

import org.rascalmpl.java.lang.Enum;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.javax.annotation.Nullable;

final class AdaptingIntegerArray
extends Object {
    @Nullable
    private byte[] byteBacking;
    @Nullable
    private short[] shortBacking;
    @Nullable
    private int[] intBacking;
    @Nullable
    private long[] longBacking;
    private ArrayCellSize cellSize;

    AdaptingIntegerArray(int size) {
        this.cellSize = ArrayCellSize.BYTE;
        this.byteBacking = new byte[size];
    }

    private AdaptingIntegerArray(AdaptingIntegerArray toCopy) {
        this.cellSize = toCopy.cellSize;
        switch (this.cellSize) {
            case BYTE: {
                this.byteBacking = Arrays.copyOf((byte[])toCopy.byteBacking, (int)toCopy.byteBacking.length);
                break;
            }
            case SHORT: {
                this.shortBacking = Arrays.copyOf((short[])toCopy.shortBacking, (int)toCopy.shortBacking.length);
                break;
            }
            case INT: {
                this.intBacking = Arrays.copyOf((int[])toCopy.intBacking, (int)toCopy.intBacking.length);
                break;
            }
            case LONG: {
                this.longBacking = Arrays.copyOf((long[])toCopy.longBacking, (int)toCopy.longBacking.length);
            }
        }
    }

    AdaptingIntegerArray copy() {
        return new AdaptingIntegerArray(this);
    }

    void increment(int idx, long count) {
        switch (this.cellSize) {
            case BYTE: {
                long result = (long)this.byteBacking[idx] + count;
                if (result > 127L) {
                    this.resizeToShort();
                    this.increment(idx, count);
                    return;
                }
                this.byteBacking[idx] = (byte)result;
                return;
            }
            case SHORT: {
                long result = (long)this.shortBacking[idx] + count;
                if (result > 32767L) {
                    this.resizeToInt();
                    this.increment(idx, count);
                    return;
                }
                this.shortBacking[idx] = (short)result;
                return;
            }
            case INT: {
                long result = (long)this.intBacking[idx] + count;
                if (result > Integer.MAX_VALUE) {
                    this.resizeToLong();
                    this.increment(idx, count);
                    return;
                }
                this.intBacking[idx] = (int)result;
                return;
            }
            case LONG: {
                this.longBacking[idx] = this.longBacking[idx] + count;
                return;
            }
        }
    }

    long get(int index) {
        long value = 0L;
        switch (this.cellSize) {
            case BYTE: {
                value = this.byteBacking[index];
                break;
            }
            case SHORT: {
                value = this.shortBacking[index];
                break;
            }
            case INT: {
                value = this.intBacking[index];
                break;
            }
            case LONG: {
                value = this.longBacking[index];
            }
        }
        return value;
    }

    int length() {
        int length = 0;
        switch (this.cellSize) {
            case BYTE: {
                length = this.byteBacking.length;
                break;
            }
            case SHORT: {
                length = this.shortBacking.length;
                break;
            }
            case INT: {
                length = this.intBacking.length;
                break;
            }
            case LONG: {
                length = this.longBacking.length;
            }
        }
        return length;
    }

    void clear() {
        switch (this.cellSize) {
            case BYTE: {
                Arrays.fill((byte[])this.byteBacking, (byte)0);
                break;
            }
            case SHORT: {
                Arrays.fill((short[])this.shortBacking, (short)0);
                break;
            }
            case INT: {
                Arrays.fill((int[])this.intBacking, (int)0);
                break;
            }
            case LONG: {
                Arrays.fill((long[])this.longBacking, (long)0L);
            }
        }
    }

    private void resizeToShort() {
        short[] shortBacking = new short[this.byteBacking.length];
        for (int i = 0; i < this.byteBacking.length; ++i) {
            shortBacking[i] = this.byteBacking[i];
        }
        this.cellSize = ArrayCellSize.SHORT;
        this.shortBacking = shortBacking;
        this.byteBacking = null;
    }

    private void resizeToInt() {
        int[] intBacking = new int[this.shortBacking.length];
        for (int i = 0; i < this.shortBacking.length; ++i) {
            intBacking[i] = this.shortBacking[i];
        }
        this.cellSize = ArrayCellSize.INT;
        this.intBacking = intBacking;
        this.shortBacking = null;
    }

    private void resizeToLong() {
        long[] longBacking = new long[this.intBacking.length];
        for (int i = 0; i < this.intBacking.length; ++i) {
            longBacking[i] = this.intBacking[i];
        }
        this.cellSize = ArrayCellSize.LONG;
        this.longBacking = longBacking;
        this.intBacking = null;
    }

    private static final class ArrayCellSize
    extends Enum<ArrayCellSize> {
        public static final /* enum */ ArrayCellSize BYTE = new ArrayCellSize((String)"org.rascalmpl.BYTE", 0);
        public static final /* enum */ ArrayCellSize SHORT = new ArrayCellSize((String)"org.rascalmpl.SHORT", 1);
        public static final /* enum */ ArrayCellSize INT = new ArrayCellSize((String)"org.rascalmpl.INT", 2);
        public static final /* enum */ ArrayCellSize LONG = new ArrayCellSize((String)"org.rascalmpl.LONG", 3);
        private static final /* synthetic */ ArrayCellSize[] $VALUES;

        public static ArrayCellSize[] values() {
            return (ArrayCellSize[])$VALUES.clone();
        }

        public static ArrayCellSize valueOf(String name) {
            return (ArrayCellSize)Enum.valueOf(ArrayCellSize.class, (String)name);
        }

        private ArrayCellSize() {
            super((String)string, n);
        }

        private static /* synthetic */ ArrayCellSize[] $values() {
            return new ArrayCellSize[]{BYTE, SHORT, INT, LONG};
        }

        static {
            $VALUES = ArrayCellSize.$values();
        }
    }
}

