/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator;

import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.PointData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.java.util.List;
import org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AggregatorHandle<T extends PointData, U extends ExemplarData>
extends Object {
    private final ExemplarReservoir<U> exemplarReservoir;
    private volatile boolean valuesRecorded = false;

    protected AggregatorHandle(ExemplarReservoir<U> exemplarReservoir) {
        this.exemplarReservoir = exemplarReservoir;
    }

    public final T aggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, boolean reset) {
        if (reset) {
            this.valuesRecorded = false;
        }
        return this.doAggregateThenMaybeReset(startEpochNanos, epochNanos, attributes, this.exemplarReservoir.collectAndReset(attributes), reset);
    }

    protected abstract T doAggregateThenMaybeReset(long var1, long var3, Attributes var5, List<U> var6, boolean var7);

    public final void recordLong(long value, Attributes attributes, Context context) {
        this.exemplarReservoir.offerLongMeasurement(value, attributes, context);
        this.recordLong(value);
    }

    public final void recordLong(long value) {
        this.doRecordLong(value);
        this.valuesRecorded = true;
    }

    protected void doRecordLong(long value) {
        throw new UnsupportedOperationException((String)"org.rascalmpl.This aggregator does not support recording long values.");
    }

    public final void recordDouble(double value, Attributes attributes, Context context) {
        this.exemplarReservoir.offerDoubleMeasurement(value, attributes, context);
        this.recordDouble(value);
    }

    public final void recordDouble(double value) {
        this.doRecordDouble(value);
        this.valuesRecorded = true;
    }

    protected void doRecordDouble(double value) {
        throw new UnsupportedOperationException((String)"org.rascalmpl.This aggregator does not support recording double values.");
    }

    public boolean hasRecordedValues() {
        return this.valuesRecorded;
    }
}

