/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator;

import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.io.opentelemetry.sdk.common.export.MemoryMode;
import org.rascalmpl.io.opentelemetry.sdk.internal.PrimitiveLongList;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.MetricData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramPointData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.MutableHistogramPointData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.java.lang.Math;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.function.Supplier;
import org.rascalmpl.javax.annotation.Nullable;

public final class DoubleExplicitBucketHistogramAggregator
extends org.rascalmpl.java.lang.Object
implements Aggregator<HistogramPointData, DoubleExemplarData> {
    private final double[] boundaries;
    private final MemoryMode memoryMode;
    private final List<org.rascalmpl.java.lang.Double> boundaryList;
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleExplicitBucketHistogramAggregator(double[] boundaries, Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        this.boundaries = boundaries;
        this.memoryMode = memoryMode;
        ArrayList boundaryList = new ArrayList(this.boundaries.length);
        for (double v : this.boundaries) {
            boundaryList.add((org.rascalmpl.java.lang.Object)org.rascalmpl.java.lang.Double.valueOf((double)v));
        }
        this.boundaryList = Collections.unmodifiableList((List)boundaryList);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<HistogramPointData, DoubleExemplarData> createHandle() {
        return new Handle(this.boundaryList, this.boundaries, (ExemplarReservoir)this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Collection<HistogramPointData> pointData, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ImmutableHistogramData.create(temporality, pointData));
    }

    static final class Handle
    extends AggregatorHandle<HistogramPointData, DoubleExemplarData> {
        private final List<org.rascalmpl.java.lang.Double> boundaryList;
        private final double[] boundaries;
        private final org.rascalmpl.java.lang.Object lock = new org.rascalmpl.java.lang.Object();
        private double sum;
        private double min;
        private double max;
        private long count;
        private final long[] counts;
        @Nullable
        private MutableHistogramPointData reusablePoint;

        Handle(List<org.rascalmpl.java.lang.Double> boundaryList, double[] boundaries, ExemplarReservoir<DoubleExemplarData> reservoir, MemoryMode memoryMode) {
            super(reservoir);
            this.boundaryList = boundaryList;
            this.boundaries = boundaries;
            this.counts = new long[this.boundaries.length + 1];
            this.sum = 0.0;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
            if (memoryMode == MemoryMode.REUSABLE_DATA) {
                this.reusablePoint = new MutableHistogramPointData(this.counts.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HistogramPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            org.rascalmpl.java.lang.Object object = this.lock;
            synchronized (object) {
                HistogramPointData pointData = this.reusablePoint == null ? ImmutableHistogramPointData.create(startEpochNanos, epochNanos, attributes, this.sum, this.count > 0L, this.min, this.count > 0L, this.max, this.boundaryList, PrimitiveLongList.wrap(Arrays.copyOf((long[])this.counts, (int)this.counts.length)), exemplars) : this.reusablePoint.set(startEpochNanos, epochNanos, attributes, this.sum, this.count > 0L, this.min, this.count > 0L, this.max, this.boundaryList, this.counts, exemplars);
                if (reset) {
                    this.sum = 0.0;
                    this.min = Double.MAX_VALUE;
                    this.max = -1.0;
                    this.count = 0L;
                    Arrays.fill((long[])this.counts, (long)0L);
                }
                return pointData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRecordDouble(double value) {
            int bucketIndex = ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
            org.rascalmpl.java.lang.Object object = this.lock;
            synchronized (object) {
                this.sum += value;
                this.min = Math.min((double)this.min, (double)value);
                this.max = Math.max((double)this.max, (double)value);
                ++this.count;
                int n = bucketIndex;
                this.counts[n] = this.counts[n] + 1L;
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }
    }
}

