/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator;

import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.io.opentelemetry.sdk.common.export.MemoryMode;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.LongPointData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.MetricData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.MutableLongPointData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.java.lang.Long;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.java.util.function.Supplier;
import org.rascalmpl.javax.annotation.Nullable;

public final class LongLastValueAggregator
extends org.rascalmpl.java.lang.Object
implements Aggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public LongLastValueAggregator(Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle((ExemplarReservoir)this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public LongPointData diff(LongPointData previous, LongPointData current) {
        return current;
    }

    @Override
    public void diffInPlace(LongPointData previousReusablePoint, LongPointData currentPoint) {
        ((MutableLongPointData)previousReusablePoint).set(currentPoint);
    }

    @Override
    public LongPointData toPoint(Measurement measurement) {
        return ImmutableLongPointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public void toPoint(Measurement measurement, LongPointData reusablePoint) {
        ((MutableLongPointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.longValue());
    }

    @Override
    public LongPointData createReusablePoint() {
        return new MutableLongPointData();
    }

    @Override
    public void copyPoint(LongPointData point, LongPointData toReusablePoint) {
        ((MutableLongPointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference((org.rascalmpl.java.lang.Object)DEFAULT_VALUE);
        @Nullable
        private final MutableLongPointData reusablePoint;

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir, MemoryMode memoryMode) {
            super(exemplarReservoir);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableLongPointData() : null;
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            Long value;
            Long longVal = value = reset ? (Long)this.current.getAndSet((org.rascalmpl.java.lang.Object)DEFAULT_VALUE) : (Long)this.current.get();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, ((Long)Objects.requireNonNull((org.rascalmpl.java.lang.Object)value)).longValue(), exemplars);
                return this.reusablePoint;
            }
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, ((Long)Objects.requireNonNull((org.rascalmpl.java.lang.Object)value)).longValue(), exemplars);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set((org.rascalmpl.java.lang.Object)Long.valueOf((long)value));
        }
    }
}

