/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data;

import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.EmptyExponentialHistogramBuckets;
import org.rascalmpl.java.lang.Double;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;

public final class MutableExponentialHistogramPointData
extends Object
implements ExponentialHistogramPointData {
    private long startEpochNanos;
    private long epochNanos;
    private Attributes attributes = Attributes.empty();
    private int scale;
    private double sum;
    private long count;
    private long zeroCount;
    private boolean hasMin;
    private double min;
    private boolean hasMax;
    private double max;
    private ExponentialHistogramBuckets positiveBuckets = EmptyExponentialHistogramBuckets.get(0);
    private ExponentialHistogramBuckets negativeBuckets = EmptyExponentialHistogramBuckets.get(0);
    private List<DoubleExemplarData> exemplars = Collections.emptyList();

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getZeroCount() {
        return this.zeroCount;
    }

    @Override
    public boolean hasMin() {
        return this.hasMin;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public boolean hasMax() {
        return this.hasMax;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public ExponentialHistogramBuckets getPositiveBuckets() {
        return this.positiveBuckets;
    }

    @Override
    public ExponentialHistogramBuckets getNegativeBuckets() {
        return this.negativeBuckets;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public ExponentialHistogramPointData set(int scale, double sum, long zeroCount, boolean hasMin, double min2, boolean hasMax, double max, ExponentialHistogramBuckets positiveBuckets, ExponentialHistogramBuckets negativeBuckets, long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars) {
        this.count = zeroCount + positiveBuckets.getTotalCount() + negativeBuckets.getTotalCount();
        this.scale = scale;
        this.sum = sum;
        this.zeroCount = zeroCount;
        this.hasMin = hasMin;
        this.min = min2;
        this.hasMax = hasMax;
        this.max = max;
        this.positiveBuckets = positiveBuckets;
        this.negativeBuckets = negativeBuckets;
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.attributes = attributes;
        this.exemplars = exemplars;
        return this;
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.MutableExponentialHistogramPointData{startEpochNanos=").append(this.startEpochNanos).append((String)"org.rascalmpl., epochNanos=").append(this.epochNanos).append((String)"org.rascalmpl., attributes=").append((Object)this.attributes).append((String)"org.rascalmpl., scale=").append(this.scale).append((String)"org.rascalmpl., sum=").append(this.sum).append((String)"org.rascalmpl., count=").append(this.count).append((String)"org.rascalmpl., zeroCount=").append(this.zeroCount).append((String)"org.rascalmpl., hasMin=").append(this.hasMin).append((String)"org.rascalmpl., min=").append(this.min).append((String)"org.rascalmpl., hasMax=").append(this.hasMax).append((String)"org.rascalmpl., max=").append(this.max).append((String)"org.rascalmpl., positiveBuckets=").append((Object)this.positiveBuckets).append((String)"org.rascalmpl., negativeBuckets=").append((Object)this.negativeBuckets).append((String)"org.rascalmpl., exemplars=").append(this.exemplars).append((String)"org.rascalmpl.}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExponentialHistogramPointData) {
            ExponentialHistogramPointData that = (ExponentialHistogramPointData)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.attributes.equals(that.getAttributes()) && this.scale == that.getScale() && Double.doubleToLongBits((double)this.sum) == Double.doubleToLongBits((double)that.getSum()) && this.count == that.getCount() && this.zeroCount == that.getZeroCount() && this.hasMin == that.hasMin() && Double.doubleToLongBits((double)this.min) == Double.doubleToLongBits((double)that.getMin()) && this.hasMax == that.hasMax() && Double.doubleToLongBits((double)this.max) == Double.doubleToLongBits((double)that.getMax()) && this.positiveBuckets.equals(that.getPositiveBuckets()) && this.negativeBuckets.equals(that.getNegativeBuckets()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash *= 1000003;
        hash ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        hash *= 1000003;
        hash ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        hash *= 1000003;
        hash ^= this.attributes.hashCode();
        hash *= 1000003;
        hash ^= this.scale;
        hash *= 1000003;
        hash ^= (int)(Double.doubleToLongBits((double)this.sum) >>> 32 ^ Double.doubleToLongBits((double)this.sum));
        hash *= 1000003;
        hash ^= (int)(this.count >>> 32 ^ this.count);
        hash *= 1000003;
        hash ^= (int)(this.zeroCount >>> 32 ^ this.zeroCount);
        hash *= 1000003;
        hash ^= this.hasMin ? 1231 : 1237;
        hash *= 1000003;
        hash ^= (int)(Double.doubleToLongBits((double)this.min) >>> 32 ^ Double.doubleToLongBits((double)this.min));
        hash *= 1000003;
        hash ^= this.hasMax ? 1231 : 1237;
        hash *= 1000003;
        hash ^= (int)(Double.doubleToLongBits((double)this.max) >>> 32 ^ Double.doubleToLongBits((double)this.max));
        hash *= 1000003;
        hash ^= this.positiveBuckets.hashCode();
        hash *= 1000003;
        hash ^= this.negativeBuckets.hashCode();
        hash *= 1000003;
        return hash ^= this.exemplars.hashCode();
    }
}

