/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data;

import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.rascalmpl.io.opentelemetry.sdk.metrics.data.LongPointData;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Collections;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Objects;

public class MutableLongPointData
extends Object
implements LongPointData {
    private long value;
    private long startEpochNanos;
    private long epochNanos;
    private Attributes attributes = Attributes.empty();
    private List<LongExemplarData> exemplars = Collections.emptyList();

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<LongExemplarData> getExemplars() {
        return this.exemplars;
    }

    public void set(LongPointData point) {
        this.set(point.getStartEpochNanos(), point.getEpochNanos(), point.getAttributes(), point.getValue(), point.getExemplars());
    }

    public void set(long startEpochNanos, long epochNanos, Attributes attributes, long value) {
        this.set(startEpochNanos, epochNanos, attributes, value, (List<LongExemplarData>)Collections.emptyList());
    }

    public void set(long startEpochNanos, long epochNanos, Attributes attributes, long value, List<LongExemplarData> exemplars) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.attributes = attributes;
        this.value = value;
        this.exemplars = exemplars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongPointData)) {
            return false;
        }
        LongPointData that = (LongPointData)o;
        return this.value == that.getValue() && this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && Objects.equals((Object)this.attributes, (Object)that.getAttributes()) && Objects.equals(this.exemplars, that.getExemplars());
    }

    public int hashCode() {
        int hashcode = 1;
        hashcode *= 1000003;
        hashcode ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        hashcode *= 1000003;
        hashcode ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        hashcode *= 1000003;
        hashcode ^= this.attributes.hashCode();
        hashcode *= 1000003;
        hashcode ^= (int)(this.value >>> 32 ^ this.value);
        hashcode *= 1000003;
        return hashcode ^= this.exemplars.hashCode();
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.MutableLongPointData{value=").append(this.value).append((String)"org.rascalmpl., startEpochNanos=").append(this.startEpochNanos).append((String)"org.rascalmpl., epochNanos=").append(this.epochNanos).append((String)"org.rascalmpl., attributes=").append((Object)this.attributes).append((String)"org.rascalmpl., exemplars=").append(this.exemplars).append('}').toString();
    }
}

