/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.resources;

import org.rascalmpl.com.google.auto.value.AutoValue;
import org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.api.common.AttributesBuilder;
import org.rascalmpl.io.opentelemetry.api.internal.StringUtils;
import org.rascalmpl.io.opentelemetry.api.internal.Utils;
import org.rascalmpl.io.opentelemetry.sdk.resources.AutoValue_Resource;
import org.rascalmpl.io.opentelemetry.sdk.resources.ResourceBuilder;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Resource
extends Object {
    private static final Logger logger = Logger.getLogger((String)Resource.class.getName());
    private static final AttributeKey<String> SERVICE_NAME = AttributeKey.stringKey((String)"org.rascalmpl.service.name");
    private static final AttributeKey<String> TELEMETRY_SDK_LANGUAGE = AttributeKey.stringKey((String)"org.rascalmpl.telemetry.sdk.language");
    private static final AttributeKey<String> TELEMETRY_SDK_NAME = AttributeKey.stringKey((String)"org.rascalmpl.telemetry.sdk.name");
    private static final AttributeKey<String> TELEMETRY_SDK_VERSION = AttributeKey.stringKey((String)"org.rascalmpl.telemetry.sdk.version");
    private static final int MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_CHARS = "org.rascalmpl. should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = "org.rascalmpl. should be a ASCII string with a length not exceed 255 characters.";
    private static final Resource EMPTY = Resource.create(Attributes.empty());
    private static final Resource TELEMETRY_SDK;
    private static final Resource MANDATORY;
    private static final Resource DEFAULT;

    public static Resource getDefault() {
        return DEFAULT;
    }

    public static Resource empty() {
        return EMPTY;
    }

    public static Resource create(Attributes attributes) {
        return Resource.create(attributes, null);
    }

    public static Resource create(Attributes attributes, @Nullable String schemaUrl) {
        Resource.checkAttributes((Attributes)Objects.requireNonNull((Object)attributes, (String)"org.rascalmpl.attributes"));
        return new AutoValue_Resource(schemaUrl, attributes);
    }

    @Nullable
    public abstract String getSchemaUrl();

    public abstract Attributes getAttributes();

    @Nullable
    public <T extends Object> T getAttribute(AttributeKey<T> key) {
        return this.getAttributes().get(key);
    }

    public Resource merge(@Nullable Resource other) {
        if (other == null || other == EMPTY) {
            return this;
        }
        AttributesBuilder attrBuilder = Attributes.builder();
        attrBuilder.putAll(this.getAttributes());
        attrBuilder.putAll(other.getAttributes());
        if (other.getSchemaUrl() == null) {
            return Resource.create(attrBuilder.build(), this.getSchemaUrl());
        }
        if (this.getSchemaUrl() == null) {
            return Resource.create(attrBuilder.build(), other.getSchemaUrl());
        }
        if (!other.getSchemaUrl().equals((Object)this.getSchemaUrl())) {
            logger.info(new StringBuilder().append((String)"org.rascalmpl.Attempting to merge Resources with different schemaUrls. The resulting Resource will have no schemaUrl assigned. Schema 1: ").append(this.getSchemaUrl()).append((String)"org.rascalmpl. Schema 2: ").append(other.getSchemaUrl()).toString());
            return Resource.create(attrBuilder.build(), null);
        }
        return Resource.create(attrBuilder.build(), this.getSchemaUrl());
    }

    /*
     * Exception decompiling
     */
    private static void checkAttributes(Attributes attributes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;Lorg/rascalmpl/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isValid(String name) {
        return name.length() <= 255 && StringUtils.isPrintableString(name);
    }

    private static boolean isValidAndNotEmpty(AttributeKey<?> name) {
        return !name.getKey().isEmpty() && Resource.isValid(name.getKey());
    }

    public static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    public ResourceBuilder toBuilder() {
        ResourceBuilder resourceBuilder = Resource.builder().putAll(this);
        if (this.getSchemaUrl() != null) {
            resourceBuilder.setSchemaUrl(this.getSchemaUrl());
        }
        return resourceBuilder;
    }

    Resource() {
    }

    private static /* synthetic */ void lambda$checkAttributes$0(AttributeKey key, Object value) {
        Utils.checkArgument(Resource.isValidAndNotEmpty(key), (String)"org.rascalmpl.Attribute key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
        Objects.requireNonNull((Object)value, (String)"org.rascalmpl.Attribute value should be a ASCII string with a length not exceed 255 characters.");
    }

    static {
        MANDATORY = Resource.create(Attributes.of(SERVICE_NAME, "org.rascalmpl.unknown_service:java"));
        TELEMETRY_SDK = Resource.create(Attributes.builder().put(TELEMETRY_SDK_NAME, "org.rascalmpl.opentelemetry").put(TELEMETRY_SDK_LANGUAGE, "org.rascalmpl.java").put(TELEMETRY_SDK_VERSION, "org.rascalmpl.1.39.0").build());
        DEFAULT = MANDATORY.merge(TELEMETRY_SDK);
    }
}

