/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.trace;

import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.io.opentelemetry.sdk.trace.ReadWriteSpan;
import org.rascalmpl.io.opentelemetry.sdk.trace.ReadableSpan;
import org.rascalmpl.io.opentelemetry.sdk.trace.SpanProcessor;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;

final class MultiSpanProcessor
extends Object
implements SpanProcessor {
    private final List<SpanProcessor> spanProcessorsStart;
    private final List<SpanProcessor> spanProcessorsEnd;
    private final List<SpanProcessor> spanProcessorsAll;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    static SpanProcessor create(List<SpanProcessor> spanProcessorList) {
        return new MultiSpanProcessor((List<SpanProcessor>)new ArrayList((Collection)Objects.requireNonNull(spanProcessorList, (String)"org.rascalmpl.spanProcessorList")));
    }

    @Override
    public void onStart(Context parentContext, ReadWriteSpan readWriteSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessorsStart) {
            spanProcessor.onStart(parentContext, readWriteSpan);
        }
    }

    @Override
    public boolean isStartRequired() {
        return !this.spanProcessorsStart.isEmpty();
    }

    @Override
    public void onEnd(ReadableSpan readableSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessorsEnd) {
            spanProcessor.onEnd(readableSpan);
        }
    }

    @Override
    public boolean isEndRequired() {
        return !this.spanProcessorsEnd.isEmpty();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList results = new ArrayList(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            results.add((Object)spanProcessor.shutdown());
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    @Override
    public CompletableResultCode forceFlush() {
        ArrayList results = new ArrayList(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            results.add((Object)spanProcessor.forceFlush());
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    private MultiSpanProcessor(List<SpanProcessor> spanProcessors) {
        this.spanProcessorsAll = spanProcessors;
        this.spanProcessorsStart = new ArrayList(this.spanProcessorsAll.size());
        this.spanProcessorsEnd = new ArrayList(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            if (spanProcessor.isStartRequired()) {
                this.spanProcessorsStart.add((Object)spanProcessor);
            }
            if (!spanProcessor.isEndRequired()) continue;
            this.spanProcessorsEnd.add((Object)spanProcessor);
        }
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.MultiSpanProcessor{spanProcessorsStart=").append(this.spanProcessorsStart).append((String)"org.rascalmpl., spanProcessorsEnd=").append(this.spanProcessorsEnd).append((String)"org.rascalmpl., spanProcessorsAll=").append(this.spanProcessorsAll).append('}').toString();
    }
}

