/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.trace.data;

import org.rascalmpl.com.google.auto.value.AutoValue;
import org.rascalmpl.io.opentelemetry.api.trace.StatusCode;
import org.rascalmpl.io.opentelemetry.sdk.trace.data.AutoValue_ImmutableStatusData;
import org.rascalmpl.io.opentelemetry.sdk.trace.data.StatusData;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class ImmutableStatusData
extends Object
implements StatusData {
    static final StatusData OK = ImmutableStatusData.createInternal(StatusCode.OK, (String)"org.rascalmpl.");
    static final StatusData UNSET = ImmutableStatusData.createInternal(StatusCode.UNSET, (String)"org.rascalmpl.");
    static final StatusData ERROR = ImmutableStatusData.createInternal(StatusCode.ERROR, (String)"org.rascalmpl.");

    ImmutableStatusData() {
    }

    static StatusData create(StatusCode statusCode, String description) {
        if (description == null || description.isEmpty()) {
            switch (statusCode) {
                case UNSET: {
                    return StatusData.unset();
                }
                case OK: {
                    return StatusData.ok();
                }
                case ERROR: {
                    return StatusData.error();
                }
            }
        }
        return ImmutableStatusData.createInternal(statusCode, description);
    }

    private static StatusData createInternal(StatusCode statusCode, String description) {
        return new AutoValue_ImmutableStatusData(statusCode, description);
    }
}

