/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.trace.export;

import org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.io.opentelemetry.sdk.trace.data.SpanData;
import org.rascalmpl.io.opentelemetry.sdk.trace.export.MultiSpanExporter;
import org.rascalmpl.io.opentelemetry.sdk.trace.export.NoopSpanExporter;
import org.rascalmpl.java.io.Closeable;
import org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.java.util.Arrays;
import org.rascalmpl.java.util.Collection;
import org.rascalmpl.java.util.List;
import org.rascalmpl.java.util.concurrent.TimeUnit;

public interface SpanExporter
extends Closeable {
    public static SpanExporter composite(SpanExporter ... exporters) {
        return SpanExporter.composite((Iterable<SpanExporter>)Arrays.asList((Object[])exporters));
    }

    public static SpanExporter composite(Iterable<SpanExporter> exporters) {
        ArrayList exportersList = new ArrayList();
        for (SpanExporter exporter : exporters) {
            exportersList.add((Object)exporter);
        }
        if (exportersList.isEmpty()) {
            return NoopSpanExporter.getInstance();
        }
        if (exportersList.size() == 1) {
            return (SpanExporter)exportersList.get(0);
        }
        return MultiSpanExporter.create((List<SpanExporter>)exportersList);
    }

    public CompletableResultCode export(Collection<SpanData> var1);

    public CompletableResultCode flush();

    public CompletableResultCode shutdown();

    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

