/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.trace.internal;

import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues.MessagePassingQueue;
import org.rascalmpl.io.opentelemetry.internal.shaded.jctools.queues.MpscArrayQueue;
import org.rascalmpl.java.lang.ExceptionInInitializerError;
import org.rascalmpl.java.lang.NoClassDefFoundError;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.java.util.Queue;
import org.rascalmpl.java.util.concurrent.ArrayBlockingQueue;
import org.rascalmpl.java.util.concurrent.atomic.AtomicBoolean;
import org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.java.util.logging.Logger;

public final class JcTools
extends Object {
    private static final AtomicBoolean queueCreationWarningLogged = new AtomicBoolean();
    private static final Logger logger = Logger.getLogger((String)JcTools.class.getName());

    public static <T extends Object> Queue<T> newFixedSizeQueue(int capacity) {
        try {
            return new MpscArrayQueue(capacity);
        }
        catch (ExceptionInInitializerError | NoClassDefFoundError e) {
            if (!queueCreationWarningLogged.getAndSet(true)) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.Cannot create high-performance queue, reverting to ArrayBlockingQueue ({0})", (Object)Objects.toString((Object)e, (String)"org.rascalmpl.unknown cause"));
            }
            return new ArrayBlockingQueue(capacity);
        }
    }

    public static long capacity(Queue<?> queue) {
        if (queue instanceof MessagePassingQueue) {
            return ((MessagePassingQueue)queue).capacity();
        }
        return (long)((ArrayBlockingQueue)queue).remainingCapacity() + (long)queue.size();
    }

    /*
     * Exception decompiling
     */
    public static <T extends Object> void drain(Queue<T> queue, int limit, Consumer<T> consumer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T extends Object> void drainNonJcQueue(Queue<T> queue, int maxExportBatchSize, Consumer<T> consumer) {
        Object item;
        int polledCount = 0;
        while (polledCount++ < maxExportBatchSize && (item = queue.poll()) != null) {
            consumer.accept(item);
        }
    }

    private JcTools() {
    }
}

