/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.trace.samplers;

import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.api.trace.SpanKind;
import org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.io.opentelemetry.sdk.trace.data.LinkData;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.AlwaysOffSampler;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.AlwaysOnSampler;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.ParentBasedSamplerBuilder;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.SamplingResult;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.TraceIdRatioBasedSampler;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.List;
import org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Sampler {
    public static Sampler alwaysOn() {
        return AlwaysOnSampler.INSTANCE;
    }

    public static Sampler alwaysOff() {
        return AlwaysOffSampler.INSTANCE;
    }

    public static Sampler parentBased(Sampler root) {
        return Sampler.parentBasedBuilder(root).build();
    }

    public static ParentBasedSamplerBuilder parentBasedBuilder(Sampler root) {
        return new ParentBasedSamplerBuilder(root);
    }

    public static Sampler traceIdRatioBased(double ratio) {
        return TraceIdRatioBasedSampler.create(ratio);
    }

    public SamplingResult shouldSample(Context var1, String var2, String var3, SpanKind var4, Attributes var5, List<LinkData> var6);

    public String getDescription();
}

