/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.io.opentelemetry.sdk.trace.samplers;

import org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.io.opentelemetry.api.trace.TraceState;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.ImmutableSamplingResult;
import org.rascalmpl.io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import org.rascalmpl.java.lang.AssertionError;
import org.rascalmpl.java.lang.Object;
import org.rascalmpl.java.lang.String;
import org.rascalmpl.java.util.Objects;
import org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public interface SamplingResult {
    public static SamplingResult create(SamplingDecision decision) {
        switch (decision) {
            case RECORD_AND_SAMPLE: {
                return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
            }
            case RECORD_ONLY: {
                return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
            }
            case DROP: {
                return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
            }
        }
        throw new AssertionError((Object)"org.rascalmpl.unrecognised samplingResult");
    }

    public static SamplingResult create(SamplingDecision decision, Attributes attributes) {
        Objects.requireNonNull((Object)attributes, (String)"org.rascalmpl.attributes");
        return attributes.isEmpty() ? SamplingResult.create(decision) : ImmutableSamplingResult.createSamplingResult(decision, attributes);
    }

    public static SamplingResult recordAndSample() {
        return ImmutableSamplingResult.EMPTY_RECORDED_AND_SAMPLED_SAMPLING_RESULT;
    }

    public static SamplingResult recordOnly() {
        return ImmutableSamplingResult.EMPTY_RECORDED_SAMPLING_RESULT;
    }

    public static SamplingResult drop() {
        return ImmutableSamplingResult.EMPTY_NOT_SAMPLED_OR_RECORDED_SAMPLING_RESULT;
    }

    public SamplingDecision getDecision();

    public Attributes getAttributes();

    default public TraceState getUpdatedTraceState(TraceState parentTraceState) {
        return parentTraceState;
    }
}

